/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack;

import com.evanlennick.retry4j.CallExecutorBuilder;
import com.evanlennick.retry4j.Status;
import com.evanlennick.retry4j.config.RetryConfigBuilder;
import io.github.pmckeown.dependencytrack.PollingConfig;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.inject.Singleton;

@Singleton
public class Poller<T> {
    public Optional<T> poll(PollingConfig pollingConfig, Callable<Optional<T>> callable) {
        Status status = new CallExecutorBuilder().config(new RetryConfigBuilder().withMaxNumberOfTries(pollingConfig.isEnabled() ? pollingConfig.getAttempts() : 1).withDelayBetweenTries((long)pollingConfig.getPause(), pollingConfig.getChronoUnit()).retryOnReturnValue(Optional.empty()).withFixedBackoff().failOnAnyException().build()).build().execute(callable);
        return (Optional)status.getResult();
    }

    public T poll(PollingConfig pollingConfig, Object retryValue, Callable<T> callable) {
        Status status = new CallExecutorBuilder().config(new RetryConfigBuilder().withMaxNumberOfTries(pollingConfig.isEnabled() ? pollingConfig.getAttempts() : 1).withDelayBetweenTries((long)pollingConfig.getPause(), pollingConfig.getChronoUnit()).retryOnReturnValue(retryValue).withFixedBackoff().failOnAnyException().build()).build().execute(callable);
        return (T)status.getResult();
    }
}

