/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack.bom;

import io.github.pmckeown.dependencytrack.project.ProjectInfo;
import io.github.pmckeown.util.Logger;
import java.io.File;
import java.io.InputStream;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.parsers.BomParserFactory;

@Singleton
public class BomParser {
    private Logger logger;

    @Inject
    public BomParser(Logger logger) {
        this.logger = logger;
    }

    public Optional<ProjectInfo> getProjectInfo(File bomFile) {
        Bom bom;
        if (!bomFile.canRead()) {
            this.logger.warn("Can not read bom {}", bomFile);
            return Optional.empty();
        }
        try (BOMInputStream bis = ((BOMInputStream.Builder)BOMInputStream.builder().setFile(bomFile)).setInclude(false).get();){
            byte[] bytes = IOUtils.toByteArray((InputStream)bis);
            bom = BomParserFactory.createParser((byte[])bytes).parse(bytes);
        }
        catch (Exception ex) {
            this.logger.warn("Failed to update project info. Failure processing bom.", ex);
            return Optional.empty();
        }
        if (bom.getMetadata() == null || bom.getMetadata().getComponent() == null) {
            return Optional.empty();
        }
        Component component = bom.getMetadata().getComponent();
        ProjectInfo info = new ProjectInfo();
        if (component.getType() != null) {
            info.setClassifier(component.getType().name());
        }
        info.setAuthor(component.getAuthor());
        info.setPublisher(component.getPublisher());
        info.setDescription(component.getDescription());
        info.setGroup(component.getGroup());
        info.setPurl(component.getPurl());
        info.setCpe(component.getCpe());
        if (component.getSwid() != null) {
            info.setSwidTagId(component.getSwid().getTagId());
        }
        return Optional.of(info);
    }
}

