/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack.finding;

import io.github.pmckeown.dependencytrack.DependencyTrackException;
import io.github.pmckeown.dependencytrack.Response;
import io.github.pmckeown.dependencytrack.finding.Finding;
import io.github.pmckeown.dependencytrack.finding.FindingsClient;
import io.github.pmckeown.dependencytrack.project.Project;
import io.github.pmckeown.util.Logger;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import kong.unirest.UnirestException;

@Singleton
public class FindingsAction {
    private FindingsClient findingClient;
    private Logger logger;

    @Inject
    public FindingsAction(FindingsClient findingClient, Logger logger) {
        this.findingClient = findingClient;
        this.logger = logger;
    }

    List<Finding> getFindings(Project project) throws DependencyTrackException {
        this.logger.info("Getting findings for project %s-%s", project.getName(), project.getVersion());
        try {
            Response<List<Finding>> response = this.findingClient.getFindingsForProject(project);
            Optional<List<Finding>> body = response.getBody();
            if (response.isSuccess()) {
                if (body.isPresent()) {
                    return body.get();
                }
                this.logger.info("No findings available for project %s-%s", project.getName(), project.getVersion());
                return Collections.emptyList();
            }
            throw new DependencyTrackException("Error received from server");
        }
        catch (UnirestException ex) {
            this.logger.error(ex.getMessage(), new Object[0]);
            throw new DependencyTrackException(ex.getMessage());
        }
    }
}

