/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack.finding;

import io.github.pmckeown.dependencytrack.finding.Finding;
import io.github.pmckeown.dependencytrack.finding.FindingThresholds;
import io.github.pmckeown.dependencytrack.finding.Severity;
import io.github.pmckeown.util.Logger;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FindingsAnalyser {
    private static final String ERROR_TEMPLATE = "Number of %s issues [%d] exceeds the maximum allowed [%d]";
    private Logger logger;

    @Inject
    public FindingsAnalyser(Logger logger) {
        this.logger = logger;
    }

    boolean doNumberOfFindingsBreachPolicy(List<Finding> findings, FindingThresholds findingThresholds) {
        this.logger.info("Comparing findings against defined thresholds", new Object[0]);
        if (findingThresholds == null) {
            return false;
        }
        boolean policyBreached = false;
        long critical = this.getCount(findings, Severity.CRITICAL);
        long high = this.getCount(findings, Severity.HIGH);
        long medium = this.getCount(findings, Severity.MEDIUM);
        long low = this.getCount(findings, Severity.LOW);
        long unassigned = this.getCount(findings, Severity.UNASSIGNED);
        if (findingThresholds.getCritical() != null && critical > (long)findingThresholds.getCritical().intValue()) {
            this.logger.warn(ERROR_TEMPLATE, "Critical", critical, findingThresholds.getCritical());
            policyBreached = true;
        }
        if (findingThresholds.getHigh() != null && high > (long)findingThresholds.getHigh().intValue()) {
            this.logger.warn(ERROR_TEMPLATE, "High", high, findingThresholds.getHigh());
            policyBreached = true;
        }
        if (findingThresholds.getMedium() != null && medium > (long)findingThresholds.getMedium().intValue()) {
            this.logger.warn(ERROR_TEMPLATE, "Medium", medium, findingThresholds.getMedium());
            policyBreached = true;
        }
        if (findingThresholds.getLow() != null && low > (long)findingThresholds.getLow().intValue()) {
            this.logger.warn(ERROR_TEMPLATE, "Low", low, findingThresholds.getLow());
            policyBreached = true;
        }
        if (findingThresholds.getUnassigned() != null && unassigned > (long)findingThresholds.getUnassigned().intValue()) {
            this.logger.warn(ERROR_TEMPLATE, "Unassigned", unassigned, findingThresholds.getUnassigned());
            policyBreached = true;
        }
        return policyBreached;
    }

    private long getCount(List<Finding> findings, Severity severity) {
        return findings.stream().filter(f -> f.getVulnerability().getSeverity() == severity && !f.getAnalysis().isSuppressed()).count();
    }
}

