/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack.finding;

import io.github.pmckeown.dependencytrack.AbstractDependencyTrackMojo;
import io.github.pmckeown.dependencytrack.CommonConfig;
import io.github.pmckeown.dependencytrack.DependencyTrackException;
import io.github.pmckeown.dependencytrack.ModuleConfig;
import io.github.pmckeown.dependencytrack.finding.Finding;
import io.github.pmckeown.dependencytrack.finding.FindingThresholds;
import io.github.pmckeown.dependencytrack.finding.FindingsAction;
import io.github.pmckeown.dependencytrack.finding.FindingsAnalyser;
import io.github.pmckeown.dependencytrack.finding.FindingsPrinter;
import io.github.pmckeown.dependencytrack.finding.report.FindingsReportGenerator;
import io.github.pmckeown.dependencytrack.project.Project;
import io.github.pmckeown.dependencytrack.project.ProjectAction;
import io.github.pmckeown.util.Logger;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Singleton
@Mojo(name="findings", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class FindingsMojo
extends AbstractDependencyTrackMojo {
    @Parameter(name="findingThresholds")
    private FindingThresholds findingThresholds;
    @Parameter(property="findingThresholds.critical")
    private Integer thresholdCritical;
    @Parameter(property="findingThresholds.high")
    private Integer thresholdHigh;
    @Parameter(property="findingThresholds.medium")
    private Integer thresholdMedium;
    @Parameter(property="findingThresholds.low")
    private Integer thresholdLow;
    @Parameter(property="findingThresholds.unassigned")
    private Integer thresholdUnassigned;
    @Parameter(defaultValue="${project}", readonly=true, required=false)
    private MavenProject mavenProject;
    private ProjectAction projectAction;
    private FindingsAction findingsAction;
    private FindingsPrinter findingsPrinter;
    private FindingsAnalyser findingsAnalyser;
    private FindingsReportGenerator findingsReportGenerator;

    @Inject
    public FindingsMojo(ProjectAction projectAction, FindingsAction findingsAction, FindingsPrinter findingsPrinter, FindingsAnalyser findingsAnalyser, FindingsReportGenerator findingsReportGenerator, CommonConfig commonConfig, ModuleConfig moduleConfig, Logger logger) {
        super(commonConfig, moduleConfig, logger);
        this.projectAction = projectAction;
        this.findingsAction = findingsAction;
        this.findingsPrinter = findingsPrinter;
        this.findingsAnalyser = findingsAnalyser;
        this.findingsReportGenerator = findingsReportGenerator;
    }

    @Override
    protected void performAction() throws MojoExecutionException, MojoFailureException {
        try {
            Project project = this.projectAction.getProject(this.moduleConfig);
            List<Finding> findings = this.findingsAction.getFindings(project);
            this.findingsPrinter.printFindings(project, findings);
            this.populateThresholdFromCliOptions();
            boolean policyBreached = this.findingsAnalyser.doNumberOfFindingsBreachPolicy(findings, this.findingThresholds);
            this.findingsReportGenerator.generate(this.getOutputDirectory(), findings, this.findingThresholds, policyBreached);
            if (policyBreached) {
                throw new MojoFailureException("Number of findings exceeded defined thresholds");
            }
        }
        catch (DependencyTrackException ex) {
            this.handleFailure("Error occurred when getting findings", ex);
        }
    }

    void populateThresholdFromCliOptions() {
        if (this.findingThresholds == null && (this.thresholdCritical != null || this.thresholdHigh != null || this.thresholdMedium != null || this.thresholdLow != null || this.thresholdUnassigned != null)) {
            this.findingThresholds = new FindingThresholds(this.thresholdCritical, this.thresholdHigh, this.thresholdMedium, this.thresholdLow, this.thresholdUnassigned);
        }
    }

    void setFindingThresholds(FindingThresholds findingThresholds) {
        this.findingThresholds = findingThresholds;
    }

    FindingThresholds getFindingThresholds() {
        return this.findingThresholds;
    }

    void setThresholdCritical(Integer thresholdCritical) {
        this.thresholdCritical = thresholdCritical;
    }

    void setThresholdHigh(Integer thresholdHigh) {
        this.thresholdHigh = thresholdHigh;
    }

    void setThresholdMedium(Integer thresholdMedium) {
        this.thresholdMedium = thresholdMedium;
    }

    void setThresholdLow(Integer thresholdLow) {
        this.thresholdLow = thresholdLow;
    }

    void setThresholdUnassigned(Integer thresholdUnassigned) {
        this.thresholdUnassigned = thresholdUnassigned;
    }

    private File getOutputDirectory() {
        if (this.mavenProject == null) {
            return null;
        }
        return new File(this.mavenProject.getBuild().getDirectory());
    }
}

