/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack.metrics;

import io.github.pmckeown.dependencytrack.CommonConfig;
import io.github.pmckeown.dependencytrack.DependencyTrackException;
import io.github.pmckeown.dependencytrack.Poller;
import io.github.pmckeown.dependencytrack.Response;
import io.github.pmckeown.dependencytrack.metrics.Metrics;
import io.github.pmckeown.dependencytrack.metrics.MetricsClient;
import io.github.pmckeown.dependencytrack.project.Project;
import io.github.pmckeown.util.Logger;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class MetricsAction {
    private MetricsClient metricsClient;
    private Poller<Metrics> poller;
    private CommonConfig commonConfig;
    private Logger logger;

    @Inject
    public MetricsAction(MetricsClient metricsClient, Poller<Metrics> poller, CommonConfig config, Logger logger) {
        this.metricsClient = metricsClient;
        this.poller = poller;
        this.commonConfig = config;
        this.logger = logger;
    }

    public Metrics getMetrics(Project project) throws DependencyTrackException {
        try {
            return this.pollForMetrics(project);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), new Object[0]);
            throw new DependencyTrackException(String.format("Failed to get Metrics for project: %s", project.getUuid()));
        }
    }

    private Metrics pollForMetrics(Project project) throws DependencyTrackException {
        Optional<Metrics> body = this.poller.poll(this.commonConfig.getPollingConfig(), () -> {
            this.logger.info("Polling for metrics from the Dependency-Track server", new Object[0]);
            Response<Metrics> response = this.metricsClient.getMetrics(project);
            return response.getBody();
        });
        if (body.isPresent()) {
            this.logger.debug("Metrics found for project: %s", project.getUuid());
            return body.get();
        }
        throw new DependencyTrackException("No metrics have yet been calculated. Request a metrics analysis in the Dependency Track UI.");
    }

    public void refreshMetrics(Project project) {
        this.logger.info("Requesting Metrics analysis for project: %s-%s", project.getName(), project.getVersion());
        try {
            Response<Void> response = this.metricsClient.refreshMetrics(project);
            if (response.isSuccess()) {
                this.logger.debug("Metrics refreshed", new Object[0]);
            } else {
                this.logger.debug("Metrics refresh failed, response from server: %s", response.getStatusText());
            }
        }
        catch (Exception ex) {
            this.logger.error("Failed to refresh metrics with exception: %s", ex.getMessage());
        }
    }
}

