/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack.metrics;

import io.github.pmckeown.dependencytrack.metrics.Metrics;
import io.github.pmckeown.dependencytrack.metrics.MetricsThresholds;
import io.github.pmckeown.util.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.maven.plugin.MojoFailureException;

@Singleton
public class MetricsAnalyser {
    static final String ERROR_TEMPLATE = "Number of %s issues [%d] exceeds the maximum allowed [%d]";
    private Logger logger;

    @Inject
    public MetricsAnalyser(Logger logger) {
        this.logger = logger;
    }

    void analyse(Metrics metrics, MetricsThresholds metricThresholds) throws MojoFailureException {
        this.logger.info("Comparing project metrics against defined thresholds", new Object[0]);
        boolean failed = false;
        if (metricThresholds.getCritical() != null && metrics.getCritical() > metricThresholds.getCritical()) {
            this.logger.warn(ERROR_TEMPLATE, "Critical", metrics.getCritical(), metricThresholds.getCritical());
            failed = true;
        }
        if (metricThresholds.getHigh() != null && metrics.getHigh() > metricThresholds.getHigh()) {
            this.logger.warn(ERROR_TEMPLATE, "High", metrics.getHigh(), metricThresholds.getHigh());
            failed = true;
        }
        if (metricThresholds.getMedium() != null && metrics.getMedium() > metricThresholds.getMedium()) {
            this.logger.warn(ERROR_TEMPLATE, "Medium", metrics.getMedium(), metricThresholds.getMedium());
            failed = true;
        }
        if (metricThresholds.getLow() != null && metrics.getLow() > metricThresholds.getLow()) {
            this.logger.warn(ERROR_TEMPLATE, "Low", metrics.getLow(), metricThresholds.getLow());
            failed = true;
        }
        if (metricThresholds.getUnassigned() != null && metrics.getUnassigned() > metricThresholds.getUnassigned()) {
            this.logger.warn(ERROR_TEMPLATE, "Unassigned", metrics.getUnassigned(), metricThresholds.getUnassigned());
            failed = true;
        }
        if (failed) {
            throw new MojoFailureException("Project metrics exceeded defined metric thresholds");
        }
    }
}

