/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack.policyviolation;

import io.github.pmckeown.dependencytrack.policyviolation.PolicyViolation;
import io.github.pmckeown.dependencytrack.policyviolation.ViolationState;
import io.github.pmckeown.util.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PolicyViolationsAnalyser {
    static final String ERROR_TEMPLATE = "Policy [%s] is violated under component [%s] [%s]";
    private Logger logger;

    @Inject
    public PolicyViolationsAnalyser(Logger logger) {
        this.logger = logger;
    }

    public boolean isAnyPolicyViolationBreached(List<PolicyViolation> policyViolations, boolean failOnWarn) {
        this.logger.info("Comparing policy violations against defined policy configuration", new Object[0]);
        ArrayList<PolicyViolation> policyFailures = new ArrayList<PolicyViolation>();
        ArrayList<PolicyViolation> policyWarnings = new ArrayList<PolicyViolation>();
        boolean policyBreached = false;
        policyFailures.addAll(policyViolations.stream().filter(p -> p.getPolicyCondition().getPolicy().getViolationState() == ViolationState.FAIL).collect(Collectors.toList()));
        policyWarnings.addAll(policyViolations.stream().filter(p -> p.getPolicyCondition().getPolicy().getViolationState() == ViolationState.WARN).collect(Collectors.toList()));
        if (!policyFailures.isEmpty()) {
            this.logPolicyBreach(policyFailures);
            policyBreached = true;
        }
        if (failOnWarn && !policyWarnings.isEmpty()) {
            this.logPolicyBreach(policyWarnings);
            policyBreached = true;
        }
        return policyBreached;
    }

    private void logPolicyBreach(List<PolicyViolation> policyViolationsBreached) {
        policyViolationsBreached.forEach(policyViolation -> this.logger.warn(ERROR_TEMPLATE, policyViolation.getPolicyCondition().getPolicy().getName(), policyViolation.getComponent().getName(), policyViolation.getComponent().getVersion()));
    }
}

