/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack.policyviolation;

import io.github.pmckeown.dependencytrack.CommonConfig;
import io.github.pmckeown.dependencytrack.Response;
import io.github.pmckeown.dependencytrack.policyviolation.PolicyViolation;
import io.github.pmckeown.dependencytrack.project.Project;
import io.github.pmckeown.util.Logger;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import kong.unirest.GenericType;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;

@Singleton
class PolicyViolationsClient {
    private CommonConfig commonConfig;
    private Logger logger;

    @Inject
    PolicyViolationsClient(CommonConfig commonConfig, Logger logger) {
        this.commonConfig = commonConfig;
        this.logger = logger;
    }

    Response<List<PolicyViolation>> getPolicyViolationsForProject(Project project) {
        this.logger.debug("Getting policy violations for project: %s-%s", project.getName(), project.getVersion());
        HttpResponse httpResponse = ((GetRequest)((GetRequest)Unirest.get((String)(this.commonConfig.getDependencyTrackBaseUrl() + "/api/v1/violation/project/{uuid}")).header("X-Api-Key", this.commonConfig.getApiKey())).routeParam("uuid", project.getUuid())).asObject((GenericType)new GenericType<List<PolicyViolation>>(){});
        Optional<Object> body = httpResponse.isSuccess() ? Optional.of((List)httpResponse.getBody()) : Optional.empty();
        return new Response<List<PolicyViolation>>(httpResponse.getStatus(), httpResponse.getStatusText(), httpResponse.isSuccess(), body);
    }
}

