/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack.project;

import io.github.pmckeown.dependencytrack.AbstractDependencyTrackMojo;
import io.github.pmckeown.dependencytrack.CommonConfig;
import io.github.pmckeown.dependencytrack.DependencyTrackException;
import io.github.pmckeown.dependencytrack.ModuleConfig;
import io.github.pmckeown.dependencytrack.project.Project;
import io.github.pmckeown.dependencytrack.project.ProjectAction;
import io.github.pmckeown.util.Logger;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="delete-project", threadSafe=true)
public class DeleteProjectMojo
extends AbstractDependencyTrackMojo {
    private ProjectAction projectAction;

    @Inject
    public DeleteProjectMojo(ProjectAction projectAction, CommonConfig commonConfig, ModuleConfig moduleConfig, Logger logger) {
        super(commonConfig, moduleConfig, logger);
        this.projectAction = projectAction;
    }

    @Override
    protected void performAction() throws MojoExecutionException, MojoFailureException {
        try {
            Project project = this.projectAction.getProject(this.moduleConfig);
            boolean success = this.projectAction.deleteProject(project);
            if (!success) {
                this.handleFailure(String.format("Failed to delete project: %s-%s", this.moduleConfig.getProjectName(), this.moduleConfig.getProjectVersion()));
            }
        }
        catch (DependencyTrackException ex) {
            this.handleFailure(String.format("Exception occurred while trying to delete project: %s-%s", this.moduleConfig.getProjectName(), this.moduleConfig.getProjectVersion()), ex);
        }
    }
}

