/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack.project;

import io.github.pmckeown.dependencytrack.CommonConfig;
import io.github.pmckeown.dependencytrack.Response;
import io.github.pmckeown.dependencytrack.project.Project;
import io.github.pmckeown.dependencytrack.project.ProjectInfo;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import kong.unirest.GenericType;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import org.apache.commons.lang3.StringUtils;

@Singleton
public class ProjectClient {
    private static final String X_API_KEY = "X-Api-Key";
    private CommonConfig commonConfig;

    @Inject
    public ProjectClient(CommonConfig commonConfig) {
        this.commonConfig = commonConfig;
    }

    public Response<Project> getProject(String projectUuid, String projectName, String projectVersion) {
        HttpResponse<Project> httpResponse = StringUtils.isNotBlank((CharSequence)projectUuid) ? this.getProjectByUuid(projectUuid) : this.getProjectByNameAndVersion(projectName, projectVersion);
        Optional<Object> body = httpResponse.isSuccess() ? Optional.of((Project)httpResponse.getBody()) : Optional.empty();
        return new Response<Project>(httpResponse.getStatus(), httpResponse.getStatusText(), httpResponse.isSuccess(), body);
    }

    private HttpResponse<Project> getProjectByNameAndVersion(String projectName, String projectVersion) {
        return ((GetRequest)((GetRequest)((GetRequest)Unirest.get((String)(this.commonConfig.getDependencyTrackBaseUrl() + "/api/v1/project/lookup")).queryString("name", (Object)projectName)).queryString("version", (Object)projectVersion)).header(X_API_KEY, this.commonConfig.getApiKey())).asObject((GenericType)new GenericType<Project>(){});
    }

    private HttpResponse<Project> getProjectByUuid(String uuid) {
        return ((GetRequest)((GetRequest)Unirest.get((String)(this.commonConfig.getDependencyTrackBaseUrl() + "/api/v1/project/{uuid}")).routeParam("uuid", uuid)).header(X_API_KEY, this.commonConfig.getApiKey())).asObject((GenericType)new GenericType<Project>(){});
    }

    Response<Void> deleteProject(Project project) {
        HttpResponse httpResponse = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.delete((String)(this.commonConfig.getDependencyTrackBaseUrl() + "/api/v1/project/{uuid}")).routeParam("uuid", project.getUuid())).header(X_API_KEY, this.commonConfig.getApiKey())).asEmpty();
        return new Response<Void>(httpResponse.getStatus(), httpResponse.getStatusText(), httpResponse.isSuccess());
    }

    public Response<Void> patchProject(String uuid, ProjectInfo info) {
        HttpResponse httpResponse = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.patch((String)(this.commonConfig.getDependencyTrackBaseUrl() + "/api/v1/project/{uuid}")).routeParam("uuid", uuid)).header(X_API_KEY, this.commonConfig.getApiKey())).contentType("application/json").body((Object)info).asEmpty();
        boolean isSuccess = httpResponse.isSuccess() || httpResponse.getStatus() == 304;
        return new Response<Void>(httpResponse.getStatus(), httpResponse.getStatusText(), isSuccess);
    }
}

