/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack.report;

import io.github.pmckeown.dependencytrack.DependencyTrackException;
import io.github.pmckeown.dependencytrack.report.TransformerFactoryProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public abstract class AbstractHtmlReportWriter {
    protected TransformerFactoryProvider transformerFactoryProvider;

    protected AbstractHtmlReportWriter(TransformerFactoryProvider transformerFactoryProvider) {
        this.transformerFactoryProvider = transformerFactoryProvider;
    }

    public void write(File buildDirectory) throws DependencyTrackException {
        try {
            StreamSource stylesheet = new StreamSource(this.getStylesheetInputStream());
            StreamSource input = new StreamSource(this.getInputFile(buildDirectory));
            StreamResult output = new StreamResult(new FileOutputStream(this.getOutputFile(buildDirectory)));
            Transformer transformer = this.getSecureTransformerFactory().newTransformer(stylesheet);
            transformer.transform(input, output);
        }
        catch (Exception ex) {
            throw new DependencyTrackException("Error occurred when creating HTML report", ex);
        }
    }

    protected abstract File getInputFile(File var1);

    protected abstract File getOutputFile(File var1);

    protected abstract InputStream getStylesheetInputStream();

    public TransformerFactory getSecureTransformerFactory() throws TransformerConfigurationException {
        TransformerFactory transformerFactory = this.transformerFactoryProvider.provide();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        return transformerFactory;
    }
}

