/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack.score;

import io.github.pmckeown.dependencytrack.CommonConfig;
import io.github.pmckeown.dependencytrack.DependencyTrackException;
import io.github.pmckeown.dependencytrack.ModuleConfig;
import io.github.pmckeown.dependencytrack.Response;
import io.github.pmckeown.dependencytrack.metrics.Metrics;
import io.github.pmckeown.dependencytrack.metrics.MetricsAction;
import io.github.pmckeown.dependencytrack.project.Project;
import io.github.pmckeown.dependencytrack.project.ProjectClient;
import io.github.pmckeown.util.Logger;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
class ScoreAction {
    private ProjectClient projectClient;
    private MetricsAction metricsAction;
    private Logger logger;

    @Inject
    public ScoreAction(ProjectClient projectClient, MetricsAction metricsAction, CommonConfig commonConfig, Logger logger) {
        this.projectClient = projectClient;
        this.metricsAction = metricsAction;
        this.logger = logger;
    }

    Integer determineScore(ModuleConfig moduleConfig, Integer inheritedRiskScoreThreshold) throws DependencyTrackException {
        try {
            Response<Project> response = this.projectClient.getProject(moduleConfig.getProjectUuid(), moduleConfig.getProjectName(), moduleConfig.getProjectVersion());
            Optional<Project> body = response.getBody();
            if (response.isSuccess() && body.isPresent()) {
                return this.generateResult(body.get(), inheritedRiskScoreThreshold);
            }
            throw new DependencyTrackException(String.format("Failed to get projects from Dependency Track: %d %s", response.getStatus(), response.getStatusText()));
        }
        catch (Exception ex) {
            throw new DependencyTrackException(ex.getMessage(), ex);
        }
    }

    private Integer generateResult(Project project, Integer inheritedRiskScoreThreshold) throws DependencyTrackException {
        Metrics metrics = this.getMetricsFromProject(project);
        this.printInheritedRiskScore(project, metrics.getInheritedRiskScore(), inheritedRiskScoreThreshold);
        return metrics.getInheritedRiskScore();
    }

    private Metrics getMetricsFromProject(Project project) throws DependencyTrackException {
        Metrics metrics = project.getMetrics();
        if (metrics != null) {
            return metrics;
        }
        this.logger.info("Metrics not present, checking the server for more info", new Object[0]);
        return this.metricsAction.getMetrics(project);
    }

    private void printInheritedRiskScore(Project project, int inheritedRiskScore, Integer inheritedRiskScoreThreshold) {
        this.logger.info("========================================================================", new Object[0]);
        this.logger.info("Project: %s, Version: %s", project.getName(), project.getVersion());
        StringBuilder scoreMessage = new StringBuilder(String.format("Inherited Risk Score: %d", inheritedRiskScore));
        if (inheritedRiskScoreThreshold != null) {
            scoreMessage.append(String.format(" - Maximum allowed Inherited Risk Score: %d", inheritedRiskScoreThreshold));
        }
        if (inheritedRiskScore > 0) {
            this.logger.warn(scoreMessage.toString(), new Object[0]);
        } else {
            this.logger.info(scoreMessage.toString(), new Object[0]);
        }
        this.logger.info("========================================================================", new Object[0]);
    }
}

