/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack.upload;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.pmckeown.dependencytrack.ModuleConfig;
import io.github.pmckeown.dependencytrack.project.ProjectTag;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class UploadBomRequest {
    private final String projectName;
    private final String projectVersion;
    private final boolean autoCreate;
    private final String base64EncodedBom;
    private final Boolean isLatest;
    private final List<ProjectTag> projectTags;
    private final String parentUUID;
    private final String parentName;
    private final String parentVersion;

    UploadBomRequest(ModuleConfig moduleConfig, String base64EncodedBom) {
        this.projectName = moduleConfig.getProjectName();
        this.projectVersion = moduleConfig.getProjectVersion();
        this.autoCreate = moduleConfig.isAutoCreate();
        this.base64EncodedBom = base64EncodedBom;
        this.isLatest = moduleConfig.isLatest();
        this.projectTags = CollectionUtils.isEmpty(moduleConfig.getProjectTags()) ? null : moduleConfig.getProjectTags().stream().map(ProjectTag::new).collect(Collectors.toList());
        this.parentUUID = moduleConfig.getParentUuid();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{moduleConfig.getParentName(), moduleConfig.getParentVersion()})) {
            this.parentName = moduleConfig.getParentName();
            this.parentVersion = moduleConfig.getParentVersion();
        } else {
            this.parentName = null;
            this.parentVersion = null;
        }
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="isLatestProjectVersion")
    public Boolean getIsLatest() {
        return this.isLatest;
    }

    public String getBom() {
        return this.base64EncodedBom;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<ProjectTag> getProjectTags() {
        return this.projectTags;
    }

    public String getParentUUID() {
        return this.parentUUID;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getParentVersion() {
        return this.parentVersion;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }
}

