/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack;

import io.github.pmckeown.dependencytrack.CommonConfig;
import io.github.pmckeown.dependencytrack.ModuleConfig;
import io.github.pmckeown.dependencytrack.ObjectMapperFactory;
import io.github.pmckeown.dependencytrack.PollingConfig;
import io.github.pmckeown.util.Logger;
import kong.unirest.ObjectMapper;
import kong.unirest.Unirest;
import kong.unirest.jackson.JacksonObjectMapper;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractDependencyTrackMojo
extends AbstractMojo {
    @Parameter(required=true, defaultValue="${project.artifactId}", property="dependency-track.projectName")
    protected String projectName;
    @Parameter(required=true, defaultValue="${project.version}", property="dependency-track.projectVersion")
    protected String projectVersion;
    @Parameter(required=true, property="dependency-track.dependencyTrackBaseUrl")
    private String dependencyTrackBaseUrl;
    @Parameter(required=true, property="dependency-track.apiKey")
    private String apiKey;
    @Parameter(defaultValue="false", property="dependency-track.failOnError")
    private boolean failOnError;
    @Parameter(defaultValue="false", property="dependency-track.skip", alias="dependency-track.skip")
    private String skip = Boolean.FALSE.toString();
    @Parameter(defaultValue="true", property="dependency-track.verifySsl")
    private boolean verifySsl;
    @Parameter
    private PollingConfig pollingConfig;
    protected Logger logger;
    protected CommonConfig commonConfig;
    protected ModuleConfig moduleConfig;

    protected AbstractDependencyTrackMojo(CommonConfig commonConfig, ModuleConfig moduleConfig, Logger logger) {
        this.logger = logger;
        this.commonConfig = commonConfig;
        this.moduleConfig = moduleConfig;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.logger.setLog(this.getLog());
        this.commonConfig.setDependencyTrackBaseUrl(this.dependencyTrackBaseUrl);
        this.commonConfig.setApiKey(this.apiKey);
        this.commonConfig.setPollingConfig(this.pollingConfig != null ? this.pollingConfig : PollingConfig.defaults());
        this.moduleConfig.setProjectName(this.projectName);
        this.moduleConfig.setProjectVersion(this.projectVersion);
        this.configureUnirest();
        if (this.getSkip()) {
            this.logger.info("dependency-track.skip = true: Skipping analysis.", new Object[0]);
            return;
        }
        this.performAction();
    }

    protected abstract void performAction() throws MojoExecutionException, MojoFailureException;

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    public void setDependencyTrackBaseUrl(String url) {
        this.dependencyTrackBaseUrl = url;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setFailOnError(boolean fail) {
        this.failOnError = fail;
    }

    public void setVerifySsl(boolean verifySsl) {
        this.verifySsl = verifySsl;
    }

    public void setSkip(String skip) {
        this.skip = skip;
    }

    public void setPollingConfig(PollingConfig pollingConfig) {
        this.pollingConfig = pollingConfig;
    }

    protected void handleFailure(String message) throws MojoFailureException {
        this.getLog().error((CharSequence)message);
        if (this.failOnError) {
            throw new MojoFailureException(message);
        }
    }

    protected void handleFailure(String message, Throwable ex) throws MojoExecutionException {
        this.getLog().debug((CharSequence)message, ex);
        if (this.failOnError) {
            throw new MojoExecutionException(message);
        }
    }

    private boolean getSkip() {
        return Boolean.parseBoolean(this.skip) || "releases".equals(this.skip) && !ArtifactUtils.isSnapshot((String)this.projectVersion) || "snapshots".equals(this.skip) && ArtifactUtils.isSnapshot((String)this.projectVersion);
    }

    private void configureUnirest() {
        Unirest.config().setObjectMapper((ObjectMapper)new JacksonObjectMapper(ObjectMapperFactory.relaxedObjectMapper())).setDefaultHeader("Accept-Encoding", "gzip, deflate").setDefaultHeader("Accept", "application/json").verifySsl(this.verifySsl);
        this.logger.debug("Unirest Configuration: %s", ToStringBuilder.reflectionToString((Object)Unirest.config()));
        this.logger.info("SSL Verification enabled: %b", this.verifySsl);
    }
}

