/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack;

import io.github.pmckeown.util.Logger;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.project.MavenProject;

public class ModuleConfig {
    private String projectUuid = "";
    private String projectName = "";
    private String projectVersion = "";
    private String bomLocation;
    private String parentUuid;
    private String parentName;
    private String parentVersion;
    private MavenProject mavenProject;
    private boolean updateProjectInfo;
    private boolean updateParent;
    private boolean isLatest;
    private boolean autoCreate = true;
    private Set<String> projectTags = Collections.emptySet();
    protected Logger logger = new Logger((Log)new SystemStreamLog());

    public String getProjectUuid() {
        return this.projectUuid;
    }

    public void setProjectUuid(String projectUuid) {
        this.projectUuid = projectUuid;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    public String getBomLocation() {
        if (StringUtils.isNotBlank((CharSequence)this.bomLocation)) {
            return this.bomLocation;
        }
        String defaultLocation = this.getMavenProject().getBasedir() + "/target/bom.xml";
        this.logger.debug("bomLocation not supplied so using: %s", defaultLocation);
        return defaultLocation;
    }

    public void setBomLocation(String bomLocation) {
        this.bomLocation = bomLocation;
    }

    public String getParentUuid() {
        return this.parentUuid;
    }

    public void setParentUuid(String parentUuid) {
        this.parentUuid = parentUuid;
        if (StringUtils.isNotBlank((CharSequence)parentUuid)) {
            this.logger.info("parentUuid set to: %s", parentUuid);
            this.logger.info("clearing parentName and parentVersion", new Object[0]);
            this.setParentName(null);
            this.setParentVersion(null);
        }
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        if (StringUtils.isBlank((CharSequence)this.parentUuid)) {
            this.parentName = parentName;
        } else if (StringUtils.isNotBlank((CharSequence)this.parentUuid)) {
            this.logger.info("parentUuid set so ignoring parentName: %s", parentName);
        }
    }

    public String getParentVersion() {
        return this.parentVersion;
    }

    public void setParentVersion(String parentVersion) {
        if (StringUtils.isBlank((CharSequence)this.parentUuid)) {
            this.parentVersion = parentVersion;
        } else if (StringUtils.isNotBlank((CharSequence)this.parentUuid)) {
            this.logger.info("parentUuid set so ignoring parentVersion: %s", parentVersion);
        }
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public boolean getUpdateParent() {
        return this.updateParent;
    }

    public void setUpdateParent(boolean updateParent) {
        this.updateParent = updateParent;
    }

    public boolean getUpdateProjectInfo() {
        return this.updateProjectInfo;
    }

    public void setUpdateProjectInfo(boolean updateProjectInfo) {
        this.updateProjectInfo = updateProjectInfo;
    }

    public boolean isLatest() {
        return this.isLatest;
    }

    public void setLatest(boolean latest) {
        this.isLatest = latest;
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public Set<String> getProjectTags() {
        return this.projectTags;
    }

    public void setProjectTags(Set<String> projectTags) {
        this.projectTags = projectTags;
    }
}

