/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack;

import java.time.temporal.ChronoUnit;
import javax.inject.Singleton;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Singleton
public class PollingConfig {
    private static final boolean POLLING_ENABLED = true;
    private static final int MAX_ATTEMPTS = 20;
    private static final int PAUSE_TIME = 1;
    private static final TimeUnit TIME_UNIT_SECONDS = TimeUnit.SECONDS;
    private boolean enabled;
    private int pause;
    private int attempts;
    private TimeUnit timeUnit;

    public PollingConfig() {
    }

    public PollingConfig(boolean enabled, int pause, int attempts) {
        this(enabled, pause, attempts, TimeUnit.SECONDS);
    }

    public PollingConfig(boolean enabled, int pause, int attempts, TimeUnit timeUnit) {
        this.enabled = enabled;
        this.pause = pause;
        this.attempts = attempts;
        this.timeUnit = timeUnit;
    }

    public static PollingConfig disabled() {
        return new PollingConfig(false, 0, 0, TIME_UNIT_SECONDS);
    }

    public static PollingConfig defaults() {
        return new PollingConfig(true, 1, 20, TIME_UNIT_SECONDS);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getPause() {
        return this.pause;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public ChronoUnit getChronoUnit() {
        if (this.timeUnit == TimeUnit.MILLIS) {
            return ChronoUnit.MILLIS;
        }
        return ChronoUnit.SECONDS;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static enum TimeUnit {
        SECONDS,
        MILLIS;

    }
}

