/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack.finding;

import io.github.pmckeown.dependencytrack.finding.Component;
import io.github.pmckeown.dependencytrack.finding.Finding;
import io.github.pmckeown.dependencytrack.finding.Vulnerability;
import io.github.pmckeown.dependencytrack.project.Project;
import io.github.pmckeown.util.Logger;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;

@Singleton
class FindingsPrinter {
    private Logger logger;

    @Inject
    public FindingsPrinter(Logger logger) {
        this.logger = logger;
    }

    void printFindings(Project project, List<Finding> findings) {
        if (findings == null || findings.isEmpty()) {
            this.logger.info("No findings were retrieved for project: %s", project.getName());
            return;
        }
        this.logger.info("%d finding(s) were retrieved for project: %s", findings.size(), project.getName());
        this.logger.info("Printing findings for project %s-%s", project.getName(), project.getVersion());
        findings.forEach(finding -> {
            Vulnerability vulnerability = finding.getVulnerability();
            this.logger.info("========================================================================", new Object[0]);
            this.logger.info("%s (%s)", vulnerability.getVulnId(), vulnerability.getSource());
            this.logger.info("%s: %s", vulnerability.getSeverity().name(), this.getComponentDetails((Finding)finding));
            this.logger.info("", new Object[0]);
            List<String> wrappedDescriptionParts = this.splitString(vulnerability.getDescription());
            if (wrappedDescriptionParts != null && !wrappedDescriptionParts.isEmpty()) {
                wrappedDescriptionParts.forEach(s -> this.logger.info((String)s, new Object[0]));
            }
            if (finding.getAnalysis().isSuppressed()) {
                this.logger.info("", new Object[0]);
                this.logger.info("Suppressed - %s", finding.getAnalysis().getState().name());
            }
        });
    }

    int getPrintWidth() {
        return "========================================================================".length();
    }

    private List<String> splitString(String string) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return Collections.emptyList();
        }
        String percentEscaped = StringUtils.replace((String)string, (String)"%", (String)"%%");
        String cleaned = StringUtils.replace((String)percentEscaped, (String)"\n", (String)"");
        int chunkSize = this.getPrintWidth();
        int numberOfChunks = (cleaned.length() + chunkSize - 1) / chunkSize;
        return IntStream.range(0, numberOfChunks).mapToObj(i -> cleaned.substring(i * chunkSize, Math.min((i + 1) * chunkSize, cleaned.length()))).collect(Collectors.toList());
    }

    private String getComponentDetails(Finding finding) {
        Component component = finding.getComponent();
        return StringUtils.joinWith((String)":", (Object[])new Object[]{component.getGroup(), component.getName(), component.getVersion()});
    }
}

