/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack.finding.report;

import io.github.pmckeown.dependencytrack.finding.Finding;
import io.github.pmckeown.dependencytrack.finding.FindingThresholds;
import io.github.pmckeown.dependencytrack.finding.Severity;
import io.github.pmckeown.dependencytrack.finding.report.FindingsWrapper;
import io.github.pmckeown.dependencytrack.report.Report;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="findingsReport")
@XmlType(propOrder={"policyApplied", "policyBreached", "critical", "high", "medium", "low", "unassigned"})
public class FindingsReport
implements Report {
    private PolicyApplied policyApplied;
    private Boolean policyBreached;
    private List<Finding> findings;

    public FindingsReport() {
    }

    public FindingsReport(FindingThresholds findingThresholds, List<Finding> findings, boolean policyBreached) {
        this.policyApplied = new PolicyApplied(findingThresholds);
        this.findings = findings;
        this.policyBreached = policyBreached;
    }

    @XmlElement(name="policyApplied")
    public PolicyApplied getPolicyApplied() {
        return this.policyApplied;
    }

    @XmlElement(name="policyBreached")
    public boolean getPolicyBreached() {
        return this.policyBreached;
    }

    @XmlElement(name="critical")
    public FindingsWrapper getCritical() {
        return this.filterFindings(this.findings, Severity.CRITICAL);
    }

    @XmlElement(name="high")
    public FindingsWrapper getHigh() {
        return this.filterFindings(this.findings, Severity.HIGH);
    }

    @XmlElement(name="medium")
    public FindingsWrapper getMedium() {
        return this.filterFindings(this.findings, Severity.MEDIUM);
    }

    @XmlElement(name="low")
    public FindingsWrapper getLow() {
        return this.filterFindings(this.findings, Severity.LOW);
    }

    @XmlElement(name="unassigned")
    public FindingsWrapper getUnassigned() {
        return this.filterFindings(this.findings, Severity.UNASSIGNED);
    }

    private FindingsWrapper filterFindings(List<Finding> findings, Severity severity) {
        List<Finding> filteredFindings = findings.stream().filter(finding -> finding.getVulnerability().getSeverity() == severity).collect(Collectors.toList());
        return new FindingsWrapper(filteredFindings.size(), filteredFindings);
    }

    @XmlType(propOrder={"info", "critical", "high", "medium", "low", "unassigned"}, name="policyApplied")
    static class PolicyApplied {
        private static final String NO_POLICY_APPLIED_MESSAGE = "No policy was applied";
        private Integer critical;
        private Integer high;
        private Integer medium;
        private Integer low;
        private Integer unassigned;
        private String info;

        PolicyApplied(FindingThresholds findingThresholds) {
            if (findingThresholds != null) {
                if (findingThresholds.isEmpty()) {
                    this.info = NO_POLICY_APPLIED_MESSAGE;
                }
                this.critical = findingThresholds.getCritical();
                this.high = findingThresholds.getHigh();
                this.medium = findingThresholds.getMedium();
                this.low = findingThresholds.getLow();
                this.unassigned = findingThresholds.getUnassigned();
            }
        }

        @XmlAttribute(name="info", required=false)
        public String getInfo() {
            return this.info;
        }

        @XmlElement(name="maximumCriticalIssueCount", required=false)
        public Integer getCritical() {
            return this.critical;
        }

        @XmlElement(name="maximumHighIssueCount", required=false)
        public Integer getHigh() {
            return this.high;
        }

        @XmlElement(name="maximumMediumIssueCount", required=false)
        public Integer getMedium() {
            return this.medium;
        }

        @XmlElement(name="maximumLowIssueCount", required=false)
        public Integer getLow() {
            return this.low;
        }

        @XmlElement(name="maximumUnassignedIssueCount", required=false)
        public Integer getUnassigned() {
            return this.unassigned;
        }
    }
}

