/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack.metrics;

import io.github.pmckeown.dependencytrack.CommonConfig;
import io.github.pmckeown.dependencytrack.Response;
import io.github.pmckeown.dependencytrack.metrics.Metrics;
import io.github.pmckeown.dependencytrack.project.Project;
import io.github.pmckeown.util.Logger;
import java.util.Optional;
import javax.inject.Inject;
import kong.unirest.GenericType;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;

class MetricsClient {
    private CommonConfig commonConfig;
    private Logger logger;

    @Inject
    MetricsClient(CommonConfig commonConfig, Logger logger) {
        this.commonConfig = commonConfig;
        this.logger = logger;
    }

    Response<Metrics> getMetrics(Project project) {
        this.logger.debug("Getting metrics for project: %s-%s", project.getName(), project.getVersion());
        HttpResponse httpResponse = ((GetRequest)((GetRequest)Unirest.get((String)(this.commonConfig.getDependencyTrackBaseUrl() + "/api/v1/metrics/project/{uuid}/current")).header("X-Api-Key", this.commonConfig.getApiKey())).routeParam("uuid", project.getUuid())).asObject((GenericType)new GenericType<Metrics>(){});
        Optional<Object> body = httpResponse.isSuccess() ? Optional.of((Metrics)httpResponse.getBody()) : Optional.empty();
        return new Response<Metrics>(httpResponse.getStatus(), httpResponse.getStatusText(), httpResponse.isSuccess(), body);
    }

    public Response<Void> refreshMetrics(Project project) {
        this.logger.info("Refreshing Metrics for project: %s-%s", project.getName(), project.getVersion());
        HttpResponse httpResponse = ((GetRequest)((GetRequest)Unirest.get((String)(this.commonConfig.getDependencyTrackBaseUrl() + "/api/v1/metrics/project/{uuid}/refresh")).header("X-Api-Key", this.commonConfig.getApiKey())).routeParam("uuid", project.getUuid())).asEmpty();
        return new Response<Void>(httpResponse.getStatus(), httpResponse.getStatusText(), httpResponse.isSuccess());
    }
}

