/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack.metrics;

import io.github.pmckeown.dependencytrack.AbstractDependencyTrackMojo;
import io.github.pmckeown.dependencytrack.CommonConfig;
import io.github.pmckeown.dependencytrack.DependencyTrackException;
import io.github.pmckeown.dependencytrack.ModuleConfig;
import io.github.pmckeown.dependencytrack.metrics.Metrics;
import io.github.pmckeown.dependencytrack.metrics.MetricsAction;
import io.github.pmckeown.dependencytrack.metrics.MetricsAnalyser;
import io.github.pmckeown.dependencytrack.metrics.MetricsPrinter;
import io.github.pmckeown.dependencytrack.metrics.MetricsThresholds;
import io.github.pmckeown.dependencytrack.project.Project;
import io.github.pmckeown.dependencytrack.project.ProjectAction;
import io.github.pmckeown.util.Logger;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="metrics", defaultPhase=LifecyclePhase.VERIFY)
public class MetricsMojo
extends AbstractDependencyTrackMojo {
    private MetricsAction metricsAction;
    private ProjectAction getProjectAction;
    private MetricsPrinter metricsPrinter;
    private MetricsAnalyser metricsAnalyser;
    @Parameter(name="metricsThresholds")
    private MetricsThresholds metricsThresholds;

    @Inject
    public MetricsMojo(MetricsAction metricsAction, ProjectAction getProjectAction, MetricsPrinter metricsPrinter, MetricsAnalyser metricsAnalyser, CommonConfig commonConfig, ModuleConfig moduleConfig, Logger logger) {
        super(commonConfig, moduleConfig, logger);
        this.metricsAction = metricsAction;
        this.getProjectAction = getProjectAction;
        this.metricsPrinter = metricsPrinter;
        this.metricsAnalyser = metricsAnalyser;
    }

    @Override
    public void performAction() throws MojoExecutionException, MojoFailureException {
        try {
            Project project = this.getProjectAction.getProject(this.moduleConfig);
            this.logger.debug("Project Details: %s", project.toString());
            Metrics metrics = this.getMetrics(project);
            this.metricsPrinter.print(metrics);
            if (this.metricsThresholds != null) {
                this.metricsAnalyser.analyse(metrics, this.metricsThresholds);
            }
        }
        catch (DependencyTrackException ex) {
            this.handleFailure(ex.getMessage(), ex);
        }
    }

    private Metrics getMetrics(Project project) throws DependencyTrackException {
        if (project.getMetrics() != null) {
            return project.getMetrics();
        }
        return this.metricsAction.getMetrics(project);
    }

    void setMetricsThresholds(MetricsThresholds thresholds) {
        this.metricsThresholds = thresholds;
    }
}

