/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack.metrics;

import io.github.pmckeown.dependencytrack.metrics.Metrics;
import io.github.pmckeown.util.Logger;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;

@Singleton
class MetricsPrinter {
    private Logger logger;

    @Inject
    MetricsPrinter(Logger logger) {
        this.logger = logger;
    }

    void print(Metrics metrics) {
        this.logger.info("========================================================================", new Object[0]);
        this.logger.info(this.formatForPrinting("Metric", "Value"), new Object[0]);
        this.logger.info("========================================================================", new Object[0]);
        this.logger.info(this.formatForPrinting("Inherited Risk Score", metrics.getInheritedRiskScore()), new Object[0]);
        this.logger.info(this.formatForPrinting("Critical", metrics.getCritical()), new Object[0]);
        this.logger.info(this.formatForPrinting("High", metrics.getHigh()), new Object[0]);
        this.logger.info(this.formatForPrinting("Medium", metrics.getMedium()), new Object[0]);
        this.logger.info(this.formatForPrinting("Low", metrics.getLow()), new Object[0]);
        this.logger.info(this.formatForPrinting("Unassigned", metrics.getUnassigned()), new Object[0]);
        this.logger.info(this.formatForPrinting("Vulnerabilities", metrics.getVulnerabilities()), new Object[0]);
        this.logger.info(this.formatForPrinting("Vulnerable Components", metrics.getVulnerableComponents()), new Object[0]);
        this.logger.info(this.formatForPrinting("Components", metrics.getComponents()), new Object[0]);
        this.logger.info(this.formatForPrinting("Suppressed", metrics.getSuppressed()), new Object[0]);
        this.logger.info(this.formatForPrinting("Findings Total", metrics.getFindingsTotal()), new Object[0]);
        this.logger.info(this.formatForPrinting("Findings Audited", metrics.getFindingsAudited()), new Object[0]);
        this.logger.info(this.formatForPrinting("Findings Unaudited", metrics.getFindingsUnaudited()), new Object[0]);
        this.logger.info(this.formatForPrinting("First Occurrence", this.formatDate(metrics.getFirstOccurrence())), new Object[0]);
        this.logger.info(this.formatForPrinting("Last Occurrence", this.formatDate(metrics.getFirstOccurrence())), new Object[0]);
        this.logger.info("========================================================================", new Object[0]);
    }

    private String formatForPrinting(String key, Object value) {
        return String.format("%s | %s", StringUtils.leftPad((String)key, (int)34), value);
    }

    private String formatDate(Date date) {
        ZonedDateTime zonedDateTime = date.toInstant().atZone(ZoneId.systemDefault());
        DateTimeFormatter isoDateFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        return zonedDateTime.format(isoDateFormatter);
    }
}

