/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack.policyviolation;

import io.github.pmckeown.dependencytrack.AbstractDependencyTrackMojo;
import io.github.pmckeown.dependencytrack.CommonConfig;
import io.github.pmckeown.dependencytrack.DependencyTrackException;
import io.github.pmckeown.dependencytrack.ModuleConfig;
import io.github.pmckeown.dependencytrack.policyviolation.PolicyViolation;
import io.github.pmckeown.dependencytrack.policyviolation.PolicyViolationsAction;
import io.github.pmckeown.dependencytrack.policyviolation.PolicyViolationsAnalyser;
import io.github.pmckeown.dependencytrack.policyviolation.PolicyViolationsPrinter;
import io.github.pmckeown.dependencytrack.policyviolation.report.PolicyViolationsReportGenerator;
import io.github.pmckeown.dependencytrack.project.Project;
import io.github.pmckeown.dependencytrack.project.ProjectAction;
import io.github.pmckeown.util.Logger;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Singleton
@Mojo(name="policy-violations", defaultPhase=LifecyclePhase.VERIFY)
public class PolicyViolationsMojo
extends AbstractDependencyTrackMojo {
    @Parameter(name="failOnWarn")
    private boolean failOnWarn;
    @Parameter(defaultValue="${project}", readonly=true, required=false)
    private MavenProject mavenProject;
    private ProjectAction projectAction;
    private PolicyViolationsReportGenerator policyViolationReportGenerator;
    private PolicyViolationsAction policyAction;
    private PolicyViolationsPrinter policyViolationsPrinter;
    private PolicyViolationsAnalyser policyAnalyser;

    @Inject
    public PolicyViolationsMojo(ProjectAction projectAction, PolicyViolationsReportGenerator policyViolationReportGenerator, CommonConfig commonConfig, ModuleConfig moduleConfig, Logger logger, PolicyViolationsAction policyAction, PolicyViolationsPrinter policyViolationsPrinter, PolicyViolationsAnalyser policyAnalyser) {
        super(commonConfig, moduleConfig, logger);
        this.projectAction = projectAction;
        this.policyViolationReportGenerator = policyViolationReportGenerator;
        this.policyAction = policyAction;
        this.policyViolationsPrinter = policyViolationsPrinter;
        this.policyAnalyser = policyAnalyser;
    }

    @Override
    protected void performAction() throws MojoExecutionException, MojoFailureException {
        try {
            Project project = this.projectAction.getProject(this.moduleConfig);
            List<PolicyViolation> policyViolations = this.policyAction.getPolicyViolations(project);
            this.policyViolationsPrinter.printPolicyViolations(project, policyViolations);
            boolean policyViolationsBreached = this.policyAnalyser.isAnyPolicyViolationBreached(policyViolations, this.failOnWarn);
            this.policyViolationReportGenerator.generate(this.getOutputDirectory(), policyViolations);
            if (policyViolationsBreached) {
                throw new MojoFailureException("Policy violations breached");
            }
        }
        catch (DependencyTrackException ex) {
            this.handleFailure("Error occurred when getting policy violations", ex);
        }
    }

    private File getOutputDirectory() {
        if (this.mavenProject == null) {
            return null;
        }
        return new File(this.mavenProject.getBuild().getDirectory());
    }

    public void setFailOnWarn(boolean failOnWarn) {
        this.failOnWarn = failOnWarn;
    }
}

