/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack.project;

import com.networknt.schema.utils.StringUtils;
import io.github.pmckeown.dependencytrack.DependencyTrackException;
import io.github.pmckeown.dependencytrack.Item;
import io.github.pmckeown.dependencytrack.ModuleConfig;
import io.github.pmckeown.dependencytrack.Response;
import io.github.pmckeown.dependencytrack.bom.BomParser;
import io.github.pmckeown.dependencytrack.project.Project;
import io.github.pmckeown.dependencytrack.project.ProjectClient;
import io.github.pmckeown.dependencytrack.project.ProjectInfo;
import io.github.pmckeown.dependencytrack.project.ProjectTag;
import io.github.pmckeown.dependencytrack.project.UpdateRequest;
import io.github.pmckeown.util.Logger;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import kong.unirest.UnirestException;

@Singleton
public class ProjectAction {
    private ProjectClient projectClient;
    private BomParser bomParser;
    private Logger logger;

    @Inject
    public ProjectAction(ProjectClient projectClient, BomParser bomParser, Logger logger) {
        this.projectClient = projectClient;
        this.bomParser = bomParser;
        this.logger = logger;
    }

    public Project getProject(ModuleConfig moduleConfig) throws DependencyTrackException {
        return this.getProject(moduleConfig.getProjectUuid(), moduleConfig.getProjectName(), moduleConfig.getProjectVersion());
    }

    public Project getProject(String uuid) throws DependencyTrackException {
        return this.getProject(uuid, "", "");
    }

    public Project getProject(String name, String version) throws DependencyTrackException {
        return this.getProject("", name, version);
    }

    public Project getProject(String uuid, String name, String version) throws DependencyTrackException {
        try {
            Response<Project> response = this.projectClient.getProject(uuid, name, version);
            if (response.isSuccess()) {
                Optional<Project> body = response.getBody();
                if (body.isPresent()) {
                    return body.get();
                }
                if (StringUtils.isBlank((String)uuid)) {
                    throw new DependencyTrackException(String.format("Requested project not found by UUUID: %s", uuid));
                }
                throw new DependencyTrackException(String.format("Requested project not found by name/version: %s-%s", name, version));
            }
            this.logger.error("Failed to list projects with error from server: " + response.getStatusText(), new Object[0]);
            throw new DependencyTrackException("Failed to list projects");
        }
        catch (UnirestException ex) {
            throw new DependencyTrackException(ex.getMessage(), ex);
        }
    }

    public boolean updateProject(Project project, UpdateRequest updateReq) throws DependencyTrackException {
        return this.updateProject(project, updateReq, Collections.emptySet());
    }

    public boolean updateProject(Project project, UpdateRequest updateReq, Set<String> projectTags) throws DependencyTrackException {
        ProjectInfo info = null;
        if (updateReq.hasBomLocation()) {
            this.logger.info("Project info will be updated", new Object[0]);
            Optional<ProjectInfo> optInfo = this.bomParser.getProjectInfo(new File(updateReq.getBomLocation()));
            if (optInfo.isPresent()) {
                info = optInfo.get();
                info.setIsLatest(project.isLatest());
            } else {
                this.logger.warn("Could not create ProjectInfo from bom at location: %s", updateReq.getBomLocation());
                return false;
            }
        }
        if (projectTags != null && !projectTags.isEmpty()) {
            if (info == null) {
                info = new ProjectInfo();
            }
            if (project.getTags() != null && !project.getTags().isEmpty()) {
                this.logger.info("Merging Project Tags", new Object[0]);
                info.setTags(this.mergeTags(project.getTags(), projectTags));
            } else {
                info.setTags(projectTags.stream().map(ProjectTag::new).collect(Collectors.toList()));
            }
        }
        if (updateReq.hasParent()) {
            this.logger.info("Project parent will be updated", new Object[0]);
            if (info == null) {
                info = new ProjectInfo();
            }
            info.setParent(new Item(updateReq.getParent().getUuid()));
        }
        if (info == null) {
            return true;
        }
        try {
            this.logger.debug("Project UUID: %s", project.getUuid());
            this.logger.debug("Patch request: %s", info);
            Response<Void> response = this.projectClient.patchProject(project.getUuid(), info);
            this.logger.debug("Patch completed without error", new Object[0]);
            this.logger.debug("Response code: %s", response.getStatus());
            this.logger.debug("Success? %s", response.isSuccess());
            return response.isSuccess();
        }
        catch (UnirestException ex) {
            this.logger.error("Failed to update project info", new Object[]{ex});
            throw new DependencyTrackException("Failed to update project", ex);
        }
    }

    public boolean updateRequired(UpdateRequest updateReq) {
        return updateReq.hasBomLocation() || updateReq.hasParent();
    }

    boolean deleteProject(Project project) throws DependencyTrackException {
        try {
            this.logger.debug("Deleting project %s-%s", project.getName(), project.getVersion());
            Response<Void> response = this.projectClient.deleteProject(project);
            return response.isSuccess();
        }
        catch (UnirestException ex) {
            this.logger.error("Failed to delete project", new Object[]{ex});
            throw new DependencyTrackException("Failed to delete project");
        }
    }

    private List<ProjectTag> mergeTags(List<ProjectTag> existingTags, Set<String> mavenTags) {
        LinkedList<ProjectTag> projectTags = new LinkedList<ProjectTag>(existingTags);
        for (String mavenTag : mavenTags) {
            boolean exists = false;
            for (ProjectTag projectTag : projectTags) {
                if (!projectTag.getName().equals(mavenTag)) continue;
                exists = true;
            }
            if (exists) continue;
            projectTags.add(new ProjectTag(mavenTag));
        }
        return projectTags;
    }
}

