/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack.score;

import io.github.pmckeown.dependencytrack.AbstractDependencyTrackMojo;
import io.github.pmckeown.dependencytrack.CommonConfig;
import io.github.pmckeown.dependencytrack.DependencyTrackException;
import io.github.pmckeown.dependencytrack.ModuleConfig;
import io.github.pmckeown.dependencytrack.score.ScoreAction;
import io.github.pmckeown.util.Logger;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="score", defaultPhase=LifecyclePhase.VERIFY)
public class ScoreMojo
extends AbstractDependencyTrackMojo {
    @Parameter
    private Integer inheritedRiskScoreThreshold;
    private ScoreAction scoreAction;

    @Inject
    public ScoreMojo(ScoreAction scoreAction, ModuleConfig moduleConfig, CommonConfig commonConfig, Logger logger) {
        super(commonConfig, moduleConfig, logger);
        this.scoreAction = scoreAction;
    }

    @Override
    public void performAction() throws MojoFailureException, MojoExecutionException {
        try {
            Integer inheritedRiskScore = this.scoreAction.determineScore(this.moduleConfig, this.inheritedRiskScoreThreshold);
            this.failBuildIfThresholdIsBreached(inheritedRiskScore);
        }
        catch (DependencyTrackException ex) {
            this.handleFailure(String.format("Failed to determine score for: %s-%s", this.moduleConfig.getProjectName(), this.moduleConfig.getProjectVersion()));
        }
    }

    private void failBuildIfThresholdIsBreached(Integer inheritedRiskScore) throws MojoFailureException {
        this.logger.debug("Inherited Risk Score Threshold set to: %s", this.inheritedRiskScoreThreshold == null ? "Not set" : this.inheritedRiskScoreThreshold);
        if (this.inheritedRiskScoreThreshold != null && inheritedRiskScore > this.inheritedRiskScoreThreshold) {
            throw new MojoFailureException(String.format("Inherited Risk Score [%d] was greater than the configured threshold [%d]", inheritedRiskScore, this.inheritedRiskScoreThreshold));
        }
    }

    void setInheritedRiskScoreThreshold(Integer threshold) {
        this.inheritedRiskScoreThreshold = threshold;
    }
}

