/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack.upload;

import io.github.pmckeown.dependencytrack.CommonConfig;
import io.github.pmckeown.dependencytrack.Response;
import io.github.pmckeown.dependencytrack.upload.BomProcessingResponse;
import io.github.pmckeown.dependencytrack.upload.UploadBomRequest;
import io.github.pmckeown.dependencytrack.upload.UploadBomResponse;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import kong.unirest.GenericType;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.RequestBodyEntity;
import kong.unirest.Unirest;

@Singleton
class BomClient {
    private CommonConfig commonConfig;

    @Inject
    BomClient(CommonConfig commonConfig) {
        this.commonConfig = commonConfig;
    }

    Response<UploadBomResponse> uploadBom(UploadBomRequest bom) {
        RequestBodyEntity requestBodyEntity = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.put((String)(this.commonConfig.getDependencyTrackBaseUrl() + "/api/v1/bom")).header("Content-Type", "application/json")).header("X-Api-Key", this.commonConfig.getApiKey())).body((Object)bom);
        HttpResponse httpResponse = requestBodyEntity.asObject((GenericType)new GenericType<UploadBomResponse>(){});
        Optional<Object> body = httpResponse.isSuccess() ? Optional.of((UploadBomResponse)httpResponse.getBody()) : Optional.empty();
        return new Response<UploadBomResponse>(httpResponse.getStatus(), httpResponse.getStatusText(), httpResponse.isSuccess(), body);
    }

    Response<BomProcessingResponse> isBomBeingProcessed(String token) {
        HttpResponse httpResponse = ((GetRequest)((GetRequest)Unirest.get((String)(this.commonConfig.getDependencyTrackBaseUrl() + "/api/v1/bom/token/{uuid}")).header("X-Api-Key", this.commonConfig.getApiKey())).routeParam("uuid", token)).asObject((GenericType)new GenericType<BomProcessingResponse>(){});
        Optional<Object> body = httpResponse.isSuccess() ? Optional.of((BomProcessingResponse)httpResponse.getBody()) : Optional.empty();
        return new Response<BomProcessingResponse>(httpResponse.getStatus(), httpResponse.getStatusText(), httpResponse.isSuccess(), body);
    }
}

