/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack.upload;

import com.evanlennick.retry4j.exception.RetriesExhaustedException;
import com.evanlennick.retry4j.exception.UnexpectedException;
import io.github.pmckeown.dependencytrack.CommonConfig;
import io.github.pmckeown.dependencytrack.DependencyTrackException;
import io.github.pmckeown.dependencytrack.ModuleConfig;
import io.github.pmckeown.dependencytrack.Poller;
import io.github.pmckeown.dependencytrack.Response;
import io.github.pmckeown.dependencytrack.upload.BomClient;
import io.github.pmckeown.dependencytrack.upload.BomProcessingResponse;
import io.github.pmckeown.dependencytrack.upload.UploadBomRequest;
import io.github.pmckeown.dependencytrack.upload.UploadBomResponse;
import io.github.pmckeown.util.BomEncoder;
import io.github.pmckeown.util.Logger;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;

@Singleton
public class UploadBomAction {
    private BomClient bomClient;
    private BomEncoder bomEncoder;
    private CommonConfig commonConfig;
    private Logger logger;
    private Poller<Boolean> poller;

    @Inject
    public UploadBomAction(BomClient bomClient, BomEncoder bomEncoder, Poller<Boolean> poller, CommonConfig commonConfig, Logger logger) {
        this.bomClient = bomClient;
        this.bomEncoder = bomEncoder;
        this.poller = poller;
        this.commonConfig = commonConfig;
        this.logger = logger;
    }

    public boolean upload(ModuleConfig moduleConfig) throws DependencyTrackException {
        this.logger.info("Project Name: %s", moduleConfig.getProjectName());
        this.logger.info("Project Version: %s", moduleConfig.getProjectVersion());
        this.logger.info("Project is latest: %s", moduleConfig.isLatest());
        this.logger.info("Project Tags: %s", StringUtils.join(moduleConfig.getProjectTags(), (String)","));
        this.logger.info("Parent UUID: %s", moduleConfig.getParentUuid());
        this.logger.info("Parent Name: %s", moduleConfig.getParentName());
        this.logger.info("Parent Version: %s", moduleConfig.getParentVersion());
        this.logger.info("%s", this.commonConfig.getPollingConfig());
        Optional<String> encodedBomOptional = this.bomEncoder.encodeBom(moduleConfig.getBomLocation(), this.logger);
        if (!encodedBomOptional.isPresent()) {
            this.logger.error("No bom.xml could be located at: %s", moduleConfig.getBomLocation());
            return false;
        }
        Optional<UploadBomResponse> uploadBomResponse = this.doUpload(moduleConfig, encodedBomOptional.get());
        if (this.commonConfig.getPollingConfig().isEnabled() && uploadBomResponse.isPresent()) {
            try {
                this.pollUntilBomIsProcessed(uploadBomResponse.get());
            }
            catch (RetriesExhaustedException | UnexpectedException ex) {
                this.logger.error("Polling for processing completion was interrupted so continuing: %s", ex.getMessage());
            }
        }
        return true;
    }

    private void pollUntilBomIsProcessed(UploadBomResponse uploadBomResponse) {
        this.logger.info("Checking for BOM analysis completion", new Object[0]);
        this.poller.poll(this.commonConfig.getPollingConfig(), Boolean.TRUE, () -> {
            Response<BomProcessingResponse> response = this.bomClient.isBomBeingProcessed(uploadBomResponse.getToken());
            Optional<BomProcessingResponse> body = response.getBody();
            if (body.isPresent()) {
                boolean stillProcessing = body.get().isProcessing();
                this.logger.info("Still processing: %b", stillProcessing);
                return stillProcessing;
            }
            return Boolean.TRUE;
        });
    }

    private Optional<UploadBomResponse> doUpload(ModuleConfig moduleConfig, String encodedBom) throws DependencyTrackException {
        try {
            Response<UploadBomResponse> response = this.bomClient.uploadBom(new UploadBomRequest(moduleConfig, encodedBom));
            if (response.isSuccess()) {
                this.logger.info("BOM uploaded to Dependency Track server", new Object[0]);
                return response.getBody();
            }
            String message = String.format("Failure integrating with Dependency Track: %d %s", response.getStatus(), response.getStatusText());
            this.logger.error(message, new Object[0]);
            throw new DependencyTrackException(message);
        }
        catch (Exception ex) {
            throw new DependencyTrackException(ex.getMessage(), ex);
        }
    }
}

