/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.dependencytrack.upload;

import io.github.pmckeown.dependencytrack.AbstractDependencyTrackMojo;
import io.github.pmckeown.dependencytrack.CommonConfig;
import io.github.pmckeown.dependencytrack.DependencyTrackException;
import io.github.pmckeown.dependencytrack.ModuleConfig;
import io.github.pmckeown.dependencytrack.metrics.MetricsAction;
import io.github.pmckeown.dependencytrack.project.Project;
import io.github.pmckeown.dependencytrack.project.ProjectAction;
import io.github.pmckeown.dependencytrack.project.UpdateRequest;
import io.github.pmckeown.dependencytrack.upload.UploadBomAction;
import io.github.pmckeown.util.Logger;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="upload-bom", defaultPhase=LifecyclePhase.VERIFY)
public class UploadBomMojo
extends AbstractDependencyTrackMojo {
    @Parameter(property="dependency-track.bomLocation")
    private String bomLocation;
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject mavenProject;
    @Parameter(property="dependency-track.updateProjectInfo")
    private boolean updateProjectInfo;
    @Parameter(property="dependency-track.updateParent")
    private boolean updateParent;
    @Parameter(defaultValue="${project.parent.uuid}", property="dependency-track.parentUuid")
    private String parentUuid;
    @Parameter(defaultValue="${project.parent.name}", property="dependency-track.parentName")
    private String parentName;
    @Parameter(property="dependency-track.parentVersion")
    private String parentVersion;
    @Parameter(property="dependency-track.isLatest", defaultValue="false")
    private boolean isLatest;
    @Parameter(property="dependency-track.projectTags")
    private Set<String> projectTags;
    private final UploadBomAction uploadBomAction;
    private final MetricsAction metricsAction;
    private final ProjectAction projectAction;

    @Inject
    public UploadBomMojo(UploadBomAction uploadBomAction, MetricsAction metricsAction, ProjectAction projectAction, CommonConfig commonConfig, ModuleConfig moduleConfig, Logger logger) {
        super(commonConfig, moduleConfig, logger);
        this.uploadBomAction = uploadBomAction;
        this.metricsAction = metricsAction;
        this.projectAction = projectAction;
    }

    @Override
    public void performAction() throws MojoExecutionException, MojoFailureException {
        this.enrichConfig();
        this.logger.info("Update Project Parent : %s", this.moduleConfig.getUpdateParent());
        try {
            boolean projectUpdated;
            if (!this.uploadBomAction.upload(this.moduleConfig)) {
                this.handleFailure("Bom upload failed");
            }
            Project project = this.projectAction.getProject(this.moduleConfig);
            UpdateRequest updateReq = new UpdateRequest();
            if (this.updateProjectInfo) {
                updateReq.withBomLocation(this.getBomLocation());
            }
            if (this.updateParent) {
                updateReq.withParent(this.getProjectParent(this.moduleConfig));
            }
            if ((this.updateProjectInfo || this.updateParent) && !(projectUpdated = this.projectAction.updateProject(project, updateReq, this.projectTags))) {
                this.logger.error("Failed to update project info", new Object[0]);
                throw new DependencyTrackException("Failed to update project info");
            }
            this.metricsAction.refreshMetrics(project);
        }
        catch (DependencyTrackException ex) {
            this.handleFailure("Error occurred during upload", ex);
        }
    }

    private void enrichConfig() {
        this.moduleConfig.setBomLocation(this.getBomLocation());
        this.moduleConfig.setMavenProject(this.mavenProject);
        this.moduleConfig.setUpdateProjectInfo(this.updateProjectInfo);
        this.moduleConfig.setUpdateParent(this.updateParent);
        this.moduleConfig.setParentUuid(this.parentUuid);
        this.moduleConfig.setParentName(this.parentName);
        this.moduleConfig.setParentVersion(this.parentVersion);
        this.moduleConfig.setLatest(this.isLatest);
        this.moduleConfig.setProjectTags(this.projectTags);
    }

    private Project getProjectParent(ModuleConfig moduleConfig) throws DependencyTrackException {
        if (StringUtils.isBlank((CharSequence)moduleConfig.getParentName()) && StringUtils.isBlank((CharSequence)moduleConfig.getParentUuid())) {
            this.logger.error("Parent update requested but no parent found in parent maven project or provided in config", new Object[0]);
            throw new DependencyTrackException("No parent configured.");
        }
        if (StringUtils.isBlank((CharSequence)moduleConfig.getParentUuid())) {
            return this.getProjectParentByNameAndVersion(moduleConfig.getParentName(), moduleConfig.getParentVersion());
        }
        return this.getProjectParentByUuid(moduleConfig.getParentUuid());
    }

    private Project getProjectParentByUuid(String uuid) throws DependencyTrackException {
        this.logger.info("Attempting to fetch project parent: '%s'", uuid);
        try {
            return this.projectAction.getProject(uuid);
        }
        catch (DependencyTrackException ex) {
            this.logger.error("Failed to find parent project with UUID ['%s']. Check the update parent your settings for this plugin and verify if a matching parent project exists in the server.", uuid);
            throw ex;
        }
    }

    private Project getProjectParentByNameAndVersion(String name, String version) throws DependencyTrackException {
        this.logger.info("Attempting to fetch project parent: '%s-%s'", name, version);
        try {
            return this.projectAction.getProject(name, version);
        }
        catch (DependencyTrackException ex) {
            this.logger.error("Failed to find parent project with name ['%s-%s']. Check the update parent your settings for this plugin and verify if a matching parent project exists in the server.", name, version);
            throw ex;
        }
    }

    private String getBomLocation() {
        if (StringUtils.isNotBlank((CharSequence)this.bomLocation)) {
            return this.bomLocation;
        }
        String defaultLocation = this.mavenProject.getBasedir() + "/target/bom.xml";
        this.logger.debug("bomLocation not supplied so using: %s", defaultLocation);
        return defaultLocation;
    }

    void setBomLocation(String bomLocation) {
        this.bomLocation = bomLocation;
        this.moduleConfig.setBomLocation(bomLocation);
    }

    void setCommonConfig(CommonConfig commonConfig) {
        this.moduleConfig.setMavenProject(this.mavenProject);
        this.commonConfig = commonConfig;
    }

    CommonConfig getCommonConfig() {
        return this.commonConfig;
    }

    void setModuleConfig(ModuleConfig moduleConfig) {
        moduleConfig.setMavenProject(this.mavenProject);
        this.moduleConfig = moduleConfig;
    }

    ModuleConfig getModuleConfig() {
        return this.moduleConfig;
    }

    void setMavenProject(MavenProject mp) {
        this.mavenProject = mp;
        this.moduleConfig.setMavenProject(mp);
    }

    void setUpdateParent(boolean updateParent) {
        this.updateParent = updateParent;
        this.moduleConfig.setUpdateParent(updateParent);
    }

    public String getParentUuid() {
        return this.moduleConfig.getParentUuid();
    }

    public void setParentUuid(String parentUuid) {
        this.parentUuid = parentUuid;
        this.moduleConfig.setParentUuid(parentUuid);
    }

    void setParentName(String parentName) {
        this.parentName = parentName;
        this.moduleConfig.setParentName(parentName);
    }

    void setParentVersion(String parentVersion) {
        this.parentVersion = parentVersion;
        this.moduleConfig.setParentVersion(parentVersion);
    }

    void setLatest(boolean isLatest) {
        this.isLatest = isLatest;
        this.moduleConfig.setLatest(isLatest);
    }

    void setProjectTags(Set<String> projectTags) {
        this.projectTags = projectTags;
        this.moduleConfig.setProjectTags(projectTags);
    }
}

