/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmckeown.util;

import javax.inject.Singleton;
import org.apache.maven.plugin.logging.Log;

@Singleton
public class Logger {
    private Log log;

    public Logger() {
    }

    public Logger(Log log) {
        this.log = log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    private void assertLogSupplied() {
        if (this.log == null) {
            throw new IllegalStateException("No Log instance supplied");
        }
    }

    public void info(String template, Object ... params) {
        this.assertLogSupplied();
        if (this.log.isInfoEnabled()) {
            this.log.info((CharSequence)String.format(template, params));
        }
    }

    public void warn(String template, Object ... params) {
        this.assertLogSupplied();
        if (this.log.isWarnEnabled()) {
            this.log.warn((CharSequence)String.format(template, params));
        }
    }

    public void debug(String template, Object ... params) {
        this.assertLogSupplied();
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)String.format(template, params));
        }
    }

    public void error(String template, Object ... params) {
        this.assertLogSupplied();
        if (this.log.isErrorEnabled()) {
            this.log.error((CharSequence)String.format(template, params));
        }
    }
}

