/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import io.github.pnoker.common.exception.ServiceException;
import io.github.pnoker.common.exception.UnAuthorizedException;
import io.github.pnoker.common.model.AuthUser;
import io.github.pnoker.common.utils.AuthCacheUtil;
import io.github.pnoker.common.utils.KeyUtil;
import java.util.concurrent.TimeUnit;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class AuthUtil {
    public static String getPasswordSalt(String tenantId, String userName) {
        String saltKey = AuthCacheUtil.getSaltKey(tenantId, userName);
        if (ObjectUtil.isNull((Object)saltKey)) {
            return null;
        }
        return (String)AuthCacheUtil.getValue(saltKey);
    }

    public static String createToken(String tenantId, String userName, String salt) {
        String tokenKey = AuthCacheUtil.getUserTokenKey(tenantId, userName);
        String token = (String)AuthCacheUtil.getValue(tokenKey);
        if (CharSequenceUtil.isEmpty((CharSequence)token)) {
            token = KeyUtil.generateToken((String)userName, (String)salt, (String)tenantId);
        }
        AuthCacheUtil.setValue(tokenKey, token, 12L, TimeUnit.HOURS);
        return token;
    }

    public static String getLoginToken() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        if (ObjectUtil.isNull((Object)requestAttributes)) {
            throw new ServiceException((CharSequence)"requestAttributes cannot be null!", new Object[0]);
        }
        String token = requestAttributes.getRequest().getHeader("token");
        if (CharSequenceUtil.isBlank((CharSequence)token)) {
            throw new ServiceException((CharSequence)"please login first!", new Object[0]);
        }
        return token;
    }

    public static boolean checkLogin() {
        try {
            AuthUtil.getLoginToken();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static AuthUser getAuthUser() {
        String token = AuthUtil.getLoginToken();
        AuthUser authUser = AuthUtil.getAuthUserByToken(token);
        if (ObjectUtil.isNull((Object)authUser)) {
            throw new UnAuthorizedException((CharSequence)"please login first!", new Object[0]);
        }
        return authUser;
    }

    public static String getLoginUserId() {
        return AuthUtil.getAuthUser().getUserId();
    }

    public static void saveTokenToAuthUserMap(String token, AuthUser authUser) {
        String tokenKey = AuthCacheUtil.getTokenKey(token);
        AuthCacheUtil.setValue(tokenKey, authUser, 12L, TimeUnit.HOURS);
    }

    public static AuthUser getAuthUserByToken(String token) {
        String tokenKey = AuthCacheUtil.getTokenKey(token);
        return (AuthUser)AuthCacheUtil.getValue(tokenKey);
    }

    public static void logout() {
        String token = AuthUtil.getLoginToken();
        AuthUser authUser = AuthUtil.getAuthUserByToken(token);
        String userTokenKey = AuthCacheUtil.getUserTokenKey(authUser.getTenantId(), authUser.getUserName());
        AuthCacheUtil.deleteByKey(userTokenKey);
        String tokenKey = AuthCacheUtil.getTokenKey(token);
        AuthCacheUtil.deleteByKey(tokenKey);
    }
}

