/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import cn.hutool.extra.spring.SpringUtil;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;

public class AuthCacheUtil {
    private static final RedisTemplate redisTemplate = (RedisTemplate)SpringUtil.getBean(RedisTemplate.class);

    private AuthCacheUtil() {
        throw new IllegalStateException("Utility class");
    }

    private static String getKey(String suffix, Long tenantId, String userName) {
        return "user" + suffix + ":" + userName + "#" + tenantId;
    }

    public static String getUserTokenKey(Long tenantId, String userName) {
        return AuthCacheUtil.getKey("_token", tenantId, userName);
    }

    public static String getTokenKey(String token) {
        return "token:" + token;
    }

    public static String getSaltKey(Long tenantId, String userName) {
        return AuthCacheUtil.getKey("_salt", tenantId, userName);
    }

    public static <T> T getValue(String key) {
        ValueOperations operations = redisTemplate.opsForValue();
        return (T)operations.get((Object)key);
    }

    public static <T> void setValue(String key, T value, long time, TimeUnit unit) {
        redisTemplate.opsForValue().set((Object)key, value, time, unit);
    }

    public static boolean deleteByKey(String key) {
        return Boolean.TRUE.equals(redisTemplate.delete((Object)key));
    }
}

