/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.enums;

import java.util.Arrays;
import java.util.Optional;

public enum EntityTypeFlagEnum {
    SYSTEM("system", "\u7cfb\u7edf"),
    USER("user", "\u7528\u6237"),
    GROUP("group", "\u5206\u7ec4"),
    DRIVER("driver", "\u9a71\u52a8"),
    PROFILE("profile", "\u6a21\u677f"),
    POINT("point", "\u4f4d\u53f7"),
    DEVICE("device", "\u8bbe\u5907");

    private final String code;
    private final String remark;

    public static EntityTypeFlagEnum ofCode(String code) {
        Optional<EntityTypeFlagEnum> any = Arrays.stream(EntityTypeFlagEnum.values()).filter(type -> type.getCode().equals(code)).findFirst();
        return any.orElse(null);
    }

    public static EntityTypeFlagEnum ofName(String name) {
        try {
            return EntityTypeFlagEnum.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getCode() {
        return this.code;
    }

    public String getRemark() {
        return this.remark;
    }

    private EntityTypeFlagEnum(String code, String remark) {
        this.code = code;
        this.remark = remark;
    }
}

