/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.enums;

import java.util.Arrays;
import java.util.Optional;

public enum PointValueTypeEnum {
    BYTE("byte", "\u5b57\u8282"),
    SHORT("short", "\u77ed\u6574\u6570"),
    INT("int", "\u6574\u6570"),
    LONG("long", "\u957f\u6574\u6570"),
    FLOAT("float", "\u6d6e\u70b9\u6570"),
    DOUBLE("double", "\u53cc\u7cbe\u5ea6\u6d6e\u70b9\u6570"),
    BOOLEAN("boolean", "\u5e03\u5c14\u91cf"),
    STRING("string", "\u5b57\u7b26\u4e32"),
    HEX("hex", "\u5341\u516d\u8fdb\u5236");

    private final String code;
    private final String remark;

    public static PointValueTypeEnum ofCode(String code) {
        Optional<PointValueTypeEnum> any = Arrays.stream(PointValueTypeEnum.values()).filter(type -> type.getCode().equals(code)).findFirst();
        return any.orElse(null);
    }

    public static PointValueTypeEnum ofName(String name) {
        try {
            return PointValueTypeEnum.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getCode() {
        return this.code;
    }

    public String getRemark() {
        return this.remark;
    }

    private PointValueTypeEnum(String code, String remark) {
        this.code = code;
        this.remark = remark;
    }
}

