/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import java.util.Arrays;
import java.util.Optional;

public enum EntityTypeFlagEnum {
    SYSTEM((byte)0, "system", "\u7cfb\u7edf"),
    USER((byte)1, "user", "\u7528\u6237"),
    GROUP((byte)2, "group", "\u5206\u7ec4"),
    DRIVER((byte)3, "driver", "\u9a71\u52a8"),
    PROFILE((byte)4, "profile", "\u6a21\u7248"),
    POINT((byte)5, "point", "\u4f4d\u53f7"),
    DEVICE((byte)6, "device", "\u8bbe\u5907");

    @EnumValue
    private final Byte index;
    private final String code;
    private final String remark;

    public static EntityTypeFlagEnum ofIndex(Byte index) {
        Optional<EntityTypeFlagEnum> any = Arrays.stream(EntityTypeFlagEnum.values()).filter(type -> type.getIndex().equals(index)).findFirst();
        return any.orElse(null);
    }

    public static EntityTypeFlagEnum ofCode(String code) {
        Optional<EntityTypeFlagEnum> any = Arrays.stream(EntityTypeFlagEnum.values()).filter(type -> type.getCode().equals(code)).findFirst();
        return any.orElse(null);
    }

    public static EntityTypeFlagEnum ofName(String name) {
        try {
            return EntityTypeFlagEnum.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Byte getIndex() {
        return this.index;
    }

    public String getCode() {
        return this.code;
    }

    public String getRemark() {
        return this.remark;
    }

    private EntityTypeFlagEnum(Byte index, String code, String remark) {
        this.index = index;
        this.code = code;
        this.remark = remark;
    }
}

