/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.driver.entity.bean;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.github.pnoker.common.driver.entity.bean.RValue;
import java.io.Serializable;
import java.time.LocalDateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PointValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private Long deviceId;
    private Long pointId;
    private String value;
    private String rawValue;
    private LocalDateTime originTime;
    private LocalDateTime createTime;

    public PointValue(RValue value) {
        this.deviceId = value.getDevice().getId();
        this.pointId = value.getPoint().getId();
        this.rawValue = value.getValue();
        this.value = value.getFinalValue();
        this.originTime = LocalDateTime.now();
    }

    public static PointValueBuilder builder() {
        return new PointValueBuilder();
    }

    public String getId() {
        return this.id;
    }

    public Long getDeviceId() {
        return this.deviceId;
    }

    public Long getPointId() {
        return this.pointId;
    }

    public String getValue() {
        return this.value;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public LocalDateTime getOriginTime() {
        return this.originTime;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    public void setPointId(Long pointId) {
        this.pointId = pointId;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setRawValue(String rawValue) {
        this.rawValue = rawValue;
    }

    public void setOriginTime(LocalDateTime originTime) {
        this.originTime = originTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public PointValue() {
    }

    public PointValue(String id, Long deviceId, Long pointId, String value, String rawValue, LocalDateTime originTime, LocalDateTime createTime) {
        this.id = id;
        this.deviceId = deviceId;
        this.pointId = pointId;
        this.value = value;
        this.rawValue = rawValue;
        this.originTime = originTime;
        this.createTime = createTime;
    }

    public static class PointValueBuilder {
        private String id;
        private Long deviceId;
        private Long pointId;
        private String value;
        private String rawValue;
        private LocalDateTime originTime;
        private LocalDateTime createTime;

        PointValueBuilder() {
        }

        public PointValueBuilder id(String id) {
            this.id = id;
            return this;
        }

        public PointValueBuilder deviceId(Long deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public PointValueBuilder pointId(Long pointId) {
            this.pointId = pointId;
            return this;
        }

        public PointValueBuilder value(String value) {
            this.value = value;
            return this;
        }

        public PointValueBuilder rawValue(String rawValue) {
            this.rawValue = rawValue;
            return this;
        }

        public PointValueBuilder originTime(LocalDateTime originTime) {
            this.originTime = originTime;
            return this;
        }

        public PointValueBuilder createTime(LocalDateTime createTime) {
            this.createTime = createTime;
            return this;
        }

        public PointValue build() {
            return new PointValue(this.id, this.deviceId, this.pointId, this.value, this.rawValue, this.originTime, this.createTime);
        }

        public String toString() {
            return "PointValue.PointValueBuilder(id=" + this.id + ", deviceId=" + this.deviceId + ", pointId=" + this.pointId + ", value=" + this.value + ", rawValue=" + this.rawValue + ", originTime=" + String.valueOf(this.originTime) + ", createTime=" + String.valueOf(this.createTime) + ")";
        }
    }
}

