/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.driver.entity.bean;

import cn.hutool.core.text.CharSequenceUtil;
import io.github.pnoker.common.enums.PointTypeFlagEnum;
import io.github.pnoker.common.exception.EmptyException;
import io.github.pnoker.common.exception.TypeException;
import io.github.pnoker.common.exception.UnSupportException;
import java.io.Serializable;
import java.util.Objects;

public class WValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String value;
    private PointTypeFlagEnum type;

    public <T> T getValue(Class<T> clazz) {
        if (Objects.isNull(this.type)) {
            throw new UnSupportException((CharSequence)("Unsupported point type of " + String.valueOf(this.type)), new Object[0]);
        }
        if (CharSequenceUtil.isEmpty((CharSequence)this.value)) {
            throw new EmptyException((CharSequence)"Point value is empty", new Object[0]);
        }
        String message = "Point type is: {}, can't be cast to class: {}";
        return (T)(switch (this.type) {
            default -> throw new MatchException(null, null);
            case PointTypeFlagEnum.STRING -> {
                if (!clazz.equals(String.class)) {
                    throw new TypeException((CharSequence)"Point type is: {}, can't be cast to class: {}", new Object[]{this.type.getCode(), clazz.getName()});
                }
                yield this.value;
            }
            case PointTypeFlagEnum.BYTE -> {
                if (!clazz.equals(Byte.class)) {
                    throw new TypeException((CharSequence)"Point type is: {}, can't be cast to class: {}", new Object[]{this.type.getCode(), clazz.getName()});
                }
                yield Byte.valueOf(this.value);
            }
            case PointTypeFlagEnum.SHORT -> {
                if (!clazz.equals(Short.class)) {
                    throw new TypeException((CharSequence)"Point type is: {}, can't be cast to class: {}", new Object[]{this.type.getCode(), clazz.getName()});
                }
                yield Short.valueOf(this.value);
            }
            case PointTypeFlagEnum.INT -> {
                if (!clazz.equals(Integer.class)) {
                    throw new TypeException((CharSequence)"Point type is: {}, can't be cast to class: {}", new Object[]{this.type.getCode(), clazz.getName()});
                }
                yield Integer.valueOf(this.value);
            }
            case PointTypeFlagEnum.LONG -> {
                if (!clazz.equals(Long.class)) {
                    throw new TypeException((CharSequence)"Point type is: {}, can't be cast to class: {}", new Object[]{this.type.getCode(), clazz.getName()});
                }
                yield Long.valueOf(this.value);
            }
            case PointTypeFlagEnum.FLOAT -> {
                if (!clazz.equals(Float.class)) {
                    throw new TypeException((CharSequence)"Point type is: {}, can't be cast to class: {}", new Object[]{this.type.getCode(), clazz.getName()});
                }
                yield Float.valueOf(this.value);
            }
            case PointTypeFlagEnum.DOUBLE -> {
                if (!clazz.equals(Double.class)) {
                    throw new TypeException((CharSequence)"Point type is: {}, can't be cast to class: {}", new Object[]{this.type.getCode(), clazz.getName()});
                }
                yield Double.valueOf(this.value);
            }
            case PointTypeFlagEnum.BOOLEAN -> {
                if (!clazz.equals(Boolean.class)) {
                    throw new TypeException((CharSequence)"Point type is: {}, can't be cast to class: {}", new Object[]{this.type.getCode(), clazz.getName()});
                }
                yield Boolean.valueOf(this.value);
            }
        });
    }

    public static WValueBuilder builder() {
        return new WValueBuilder();
    }

    public String getValue() {
        return this.value;
    }

    public PointTypeFlagEnum getType() {
        return this.type;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setType(PointTypeFlagEnum type) {
        this.type = type;
    }

    public WValue() {
    }

    public WValue(String value, PointTypeFlagEnum type) {
        this.value = value;
        this.type = type;
    }

    public static class WValueBuilder {
        private String value;
        private PointTypeFlagEnum type;

        WValueBuilder() {
        }

        public WValueBuilder value(String value) {
            this.value = value;
            return this;
        }

        public WValueBuilder type(PointTypeFlagEnum type) {
            this.type = type;
            return this;
        }

        public WValue build() {
            return new WValue(this.value, this.type);
        }

        public String toString() {
            return "WValue.WValueBuilder(value=" + this.value + ", type=" + String.valueOf(this.type) + ")";
        }
    }
}

