/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.driver.job;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import io.github.pnoker.common.driver.entity.bo.DeviceBO;
import io.github.pnoker.common.driver.metadata.DeviceMetadata;
import io.github.pnoker.common.driver.metadata.DriverMetadata;
import io.github.pnoker.common.driver.service.DriverReadService;
import io.github.pnoker.common.enums.EnableFlagEnum;
import jakarta.annotation.Resource;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;

@Component
public class DriverReadScheduleJob
extends QuartzJobBean {
    private static final Logger log = LoggerFactory.getLogger(DriverReadScheduleJob.class);
    @Resource
    private DriverMetadata driverMetadata;
    @Resource
    private DeviceMetadata deviceMetadata;
    @Resource
    private DriverReadService driverReadService;

    protected void executeInternal(@NotNull JobExecutionContext jobExecutionContext) {
        Set<Long> deviceIds = this.driverMetadata.getDeviceIds();
        if (CollUtil.isEmpty(deviceIds)) {
            return;
        }
        for (Long deviceId : deviceIds) {
            DeviceBO entityBO = this.deviceMetadata.getCache(deviceId);
            if (!Objects.nonNull((Object)entityBO) || !EnableFlagEnum.ENABLE.equals((Object)entityBO.getEnableFlag()) || !CollUtil.isNotEmpty(entityBO.getProfileIds()) || !CollUtil.isNotEmpty(entityBO.getPointIds()) || !MapUtil.isNotEmpty(entityBO.getDriverAttributeConfigIdMap()) || !MapUtil.isNotEmpty(entityBO.getPointAttributeConfigIdMap())) continue;
            Set<Long> pointIds = entityBO.getPointIds();
            for (Long pointId : pointIds) {
                try {
                    this.driverReadService.read(deviceId, pointId);
                }
                catch (Exception e) {
                    log.error("Read device[{}], point[{}] error: {}", new Object[]{deviceId, pointId, e.getMessage(), e});
                }
            }
        }
    }
}

