/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.driver.metadata;

import cn.hutool.core.map.MapUtil;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.github.pnoker.common.driver.entity.bo.AttributeBO;
import io.github.pnoker.common.driver.entity.bo.DeviceBO;
import io.github.pnoker.common.driver.entity.dto.DriverAttributeConfigDTO;
import io.github.pnoker.common.driver.entity.dto.DriverAttributeDTO;
import io.github.pnoker.common.driver.entity.dto.PointAttributeConfigDTO;
import io.github.pnoker.common.driver.entity.dto.PointAttributeDTO;
import io.github.pnoker.common.driver.grpc.client.DeviceClient;
import io.github.pnoker.common.driver.metadata.DriverMetadata;
import io.github.pnoker.common.exception.ConfigException;
import io.github.pnoker.common.utils.JsonUtil;
import jakarta.annotation.Resource;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class DeviceMetadata {
    private static final Logger log = LoggerFactory.getLogger(DeviceMetadata.class);
    private final AsyncLoadingCache<Long, DeviceBO> cache = Caffeine.newBuilder().maximumSize(5000L).expireAfterWrite(24L, TimeUnit.HOURS).removalListener((key, value, cause) -> log.info("Remove key={}, value={} cache, reason is: {}", new Object[]{key, value, cause})).buildAsync((key, executor) -> CompletableFuture.supplyAsync(() -> {
        log.info("Load device metadata by id: {}", key);
        DeviceBO deviceBO = this.deviceClient.selectById((Long)key);
        log.info("Cache device metadata: {}", (Object)JsonUtil.toJsonString((Object)((Object)deviceBO)));
        return deviceBO;
    }, executor));
    @Resource
    private DriverMetadata driverMetadata;
    @Resource
    private DeviceClient deviceClient;

    public DeviceBO getCache(long id) {
        try {
            CompletableFuture future = this.cache.get((Object)id);
            return (DeviceBO)((Object)future.get());
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            log.error("Failed to get the device cache: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public void loadCache(long id) {
        CompletableFuture<DeviceBO> future = CompletableFuture.supplyAsync(() -> this.deviceClient.selectById(id));
        this.cache.put((Object)id, future);
    }

    public void removeCache(long id) {
        this.cache.put((Object)id, CompletableFuture.completedFuture(null));
    }

    public Map<String, AttributeBO> getDriverConfig(long deviceId) {
        Map<Long, DriverAttributeDTO> attributeMap = this.driverMetadata.getDriverAttributeIdMap();
        if (MapUtil.isEmpty(attributeMap)) {
            return MapUtil.empty();
        }
        DeviceBO device = this.getCache(deviceId);
        if (Objects.isNull((Object)device)) {
            throw new ConfigException((CharSequence)"Failed to get driver config, the device is empty", new Object[0]);
        }
        Map<Long, DriverAttributeConfigDTO> attributeConfigMap = device.getDriverAttributeConfigIdMap();
        if (MapUtil.isEmpty(attributeConfigMap)) {
            throw new ConfigException((CharSequence)"Failed to get driver config, the driver attribute config is empty", new Object[0]);
        }
        if (!attributeConfigMap.keySet().containsAll(attributeMap.keySet())) {
            throw new ConfigException((CharSequence)"Failed to get driver config, the driver attribute config is incomplete", new Object[0]);
        }
        return attributeMap.entrySet().stream().collect(Collectors.toMap(entry -> ((DriverAttributeDTO)((Object)((Object)entry.getValue()))).getAttributeName(), entry -> AttributeBO.builder().type(((DriverAttributeDTO)((Object)((Object)entry.getValue()))).getAttributeTypeFlag()).value(((DriverAttributeConfigDTO)((Object)((Object)attributeConfigMap.get(entry.getKey())))).getConfigValue()).build()));
    }

    public Map<String, AttributeBO> getPointConfig(long deviceId, long pointId) {
        Map<Long, PointAttributeDTO> attributeMap = this.driverMetadata.getPointAttributeIdMap();
        if (MapUtil.isEmpty(attributeMap)) {
            return MapUtil.empty();
        }
        DeviceBO device = this.getCache(deviceId);
        if (Objects.isNull((Object)device)) {
            throw new ConfigException((CharSequence)"Failed to get point config[{}:{}], the device is empty", new Object[]{deviceId, pointId});
        }
        Map<Long, Map<Long, PointAttributeConfigDTO>> pointAttributeConfigMap = device.getPointAttributeConfigIdMap();
        if (Objects.isNull(pointAttributeConfigMap)) {
            throw new ConfigException((CharSequence)"Failed to get point config[{}:{}], the device point attribute config is empty", new Object[]{deviceId, pointId});
        }
        Map<Long, PointAttributeConfigDTO> attributeConfigMap = pointAttributeConfigMap.get(pointId);
        if (MapUtil.isEmpty(attributeConfigMap)) {
            throw new ConfigException((CharSequence)"Failed to get point config[{}:{}], the point attribute config is empty", new Object[]{deviceId, pointId});
        }
        if (!attributeConfigMap.keySet().containsAll(attributeMap.keySet())) {
            throw new ConfigException((CharSequence)"Failed to get point config[{}:{}], the point attribute config is incomplete", new Object[]{deviceId, pointId});
        }
        return attributeMap.entrySet().stream().collect(Collectors.toMap(entry -> ((PointAttributeDTO)((Object)((Object)entry.getValue()))).getAttributeName(), entry -> AttributeBO.builder().type(((PointAttributeDTO)((Object)((Object)entry.getValue()))).getAttributeTypeFlag()).value(((PointAttributeConfigDTO)((Object)((Object)attributeConfigMap.get(entry.getKey())))).getConfigValue()).build()));
    }

    public Map<Long, Map<String, AttributeBO>> getPointConfig(long deviceId) {
        Map<Long, PointAttributeDTO> attributeMap = this.driverMetadata.getPointAttributeIdMap();
        if (MapUtil.isEmpty(attributeMap)) {
            return MapUtil.empty();
        }
        DeviceBO device = this.getCache(deviceId);
        if (Objects.isNull((Object)device)) {
            throw new ConfigException((CharSequence)"Failed to get point config[{}], the device is empty", new Object[]{deviceId});
        }
        Map<Long, Map<Long, PointAttributeConfigDTO>> pointAttributeConfigMap = device.getPointAttributeConfigIdMap();
        if (Objects.isNull(pointAttributeConfigMap)) {
            throw new ConfigException((CharSequence)"Failed to get point config[{}], the device point attribute config is empty", new Object[]{deviceId});
        }
        return pointAttributeConfigMap.entrySet().stream().filter(entry -> MapUtil.isEmpty((Map)((Map)entry.getValue())) && ((Map)entry.getValue()).keySet().containsAll(attributeMap.keySet())).collect(Collectors.toMap(Map.Entry::getKey, entryMap -> attributeMap.entrySet().stream().collect(Collectors.toMap(entry -> ((PointAttributeDTO)((Object)((Object)((Object)entry.getValue())))).getAttributeName(), entry -> AttributeBO.builder().type(((PointAttributeDTO)((Object)((Object)((Object)entry.getValue())))).getAttributeTypeFlag()).value(((PointAttributeConfigDTO)((Object)((Object)((Object)((Map)entryMap.getValue()).get(entry.getKey()))))).getConfigValue()).build()))));
    }
}

