/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.driver.receiver.rabbit;

import cn.hutool.core.text.CharSequenceUtil;
import com.rabbitmq.client.Channel;
import io.github.pnoker.common.driver.service.DriverReadService;
import io.github.pnoker.common.driver.service.DriverWriteService;
import io.github.pnoker.common.entity.dto.DeviceCommandDTO;
import io.github.pnoker.common.utils.JsonUtil;
import jakarta.annotation.Resource;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

@Component
public class DeviceCommandReceiver {
    private static final Logger log = LoggerFactory.getLogger(DeviceCommandReceiver.class);
    @Resource
    private DriverReadService driverReadService;
    @Resource
    private DriverWriteService driverWriteService;

    @RabbitHandler
    @RabbitListener(queues={"#{deviceCommandQueue.name}"})
    public void deviceCommandReceive(Channel channel, Message message, DeviceCommandDTO entityDTO) {
        try {
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
            log.info("Receive device command: {}", (Object)JsonUtil.toJsonString((Object)entityDTO));
            if (Objects.isNull(entityDTO) || Objects.isNull(entityDTO.getType()) || CharSequenceUtil.isEmpty((CharSequence)entityDTO.getContent())) {
                log.error("Invalid device command: {}", (Object)entityDTO);
                return;
            }
            switch (entityDTO.getType()) {
                case READ: {
                    this.driverReadService.read(entityDTO);
                    break;
                }
                case WRITE: {
                    this.driverWriteService.write(entityDTO);
                    break;
                }
                case CONFIG: {
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

