/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.driver.receiver.rabbit;

import com.rabbitmq.client.Channel;
import io.github.pnoker.common.entity.dto.DriverCommandDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

@Component
public class DriverCommandReceiver {
    private static final Logger log = LoggerFactory.getLogger(DriverCommandReceiver.class);

    @RabbitHandler
    @RabbitListener(queues={"#{driverCommandQueue.name}"})
    public void driverCommandReceive(Channel channel, Message message, DriverCommandDTO driverCommandDTO) {
        try {
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
            log.info("driver command: {}", (Object)driverCommandDTO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

