/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.driver.service.impl;

import io.github.pnoker.common.driver.entity.property.DriverProperty;
import io.github.pnoker.common.driver.entity.property.ScheduleProperty;
import io.github.pnoker.common.driver.job.DriverCustomScheduleJob;
import io.github.pnoker.common.driver.job.DriverReadScheduleJob;
import io.github.pnoker.common.driver.job.DriverStatusScheduleJob;
import io.github.pnoker.common.driver.service.DriverScheduleService;
import io.github.pnoker.common.exception.CronException;
import io.github.pnoker.common.quartz.QuartzService;
import java.util.Objects;
import org.quartz.CronExpression;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DriverScheduleServiceImpl
implements DriverScheduleService {
    private static final Logger log = LoggerFactory.getLogger(DriverScheduleServiceImpl.class);
    private final DriverProperty driverProperty;
    private final QuartzService quartzService;

    public DriverScheduleServiceImpl(DriverProperty driverProperty, QuartzService quartzService) {
        this.driverProperty = driverProperty;
        this.quartzService = quartzService;
    }

    @Override
    public void initial() {
        ScheduleProperty property = this.driverProperty.getSchedule();
        if (Objects.isNull(property)) {
            return;
        }
        try {
            this.quartzService.createJobWithCron("driver-schedule-group", "status-schedule-job", "0/15 * * * * ?", DriverStatusScheduleJob.class);
            if (Boolean.TRUE.equals(property.getRead().getEnable())) {
                if (!CronExpression.isValidExpression((String)property.getRead().getCron())) {
                    throw new CronException((CharSequence)"Read schedule cron expression is invalid", new Object[0]);
                }
                this.quartzService.createJobWithCron("driver-schedule-group", "read-schedule-job", property.getRead().getCron(), DriverReadScheduleJob.class);
            }
            if (Boolean.TRUE.equals(property.getCustom().getEnable())) {
                if (!CronExpression.isValidExpression((String)property.getCustom().getCron())) {
                    throw new CronException((CharSequence)"Custom schedule cron expression is invalid", new Object[0]);
                }
                this.quartzService.createJobWithCron("driver-schedule-group", "customs-chedule-job", property.getCustom().getCron(), DriverCustomScheduleJob.class);
            }
            this.quartzService.startScheduler();
        }
        catch (SchedulerException e) {
            log.error("Driver schedule initial error: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

