/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.entity;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Date;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoId;

@Document
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DriverEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    @MongoId
    private ObjectId id;
    private String serviceName;
    private String type;
    private Boolean confirm = false;
    private Object content;
    private Date createTime;
    private Date updateTime;

    public DriverEvent(String serviceName, String type) {
        this.serviceName = serviceName;
        this.type = type;
        this.createTime = new Date();
    }

    public DriverEvent(String serviceName, String type, Object content) {
        this.serviceName = serviceName;
        this.type = type;
        this.content = content;
        this.createTime = new Date();
    }

    public ObjectId getId() {
        return this.id;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getType() {
        return this.type;
    }

    public Boolean getConfirm() {
        return this.confirm;
    }

    public Object getContent() {
        return this.content;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setId(ObjectId id) {
        this.id = id;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setConfirm(Boolean confirm) {
        this.confirm = confirm;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DriverEvent)) {
            return false;
        }
        DriverEvent other = (DriverEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$confirm = this.getConfirm();
        Boolean other$confirm = other.getConfirm();
        if (this$confirm == null ? other$confirm != null : !((Object)this$confirm).equals(other$confirm)) {
            return false;
        }
        ObjectId this$id = this.getId();
        ObjectId other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Object this$content = this.getContent();
        Object other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$updateTime = this.getUpdateTime();
        Date other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DriverEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $confirm = this.getConfirm();
        result = result * 59 + ($confirm == null ? 43 : ((Object)$confirm).hashCode());
        ObjectId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Object $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    public String toString() {
        return "DriverEvent(id=" + this.getId() + ", serviceName=" + this.getServiceName() + ", type=" + this.getType() + ", confirm=" + this.getConfirm() + ", content=" + this.getContent() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ")";
    }

    public DriverEvent() {
    }

    public DriverEvent(ObjectId id, String serviceName, String type, Boolean confirm, Object content, Date createTime, Date updateTime) {
        this.id = id;
        this.serviceName = serviceName;
        this.type = type;
        this.confirm = confirm;
        this.content = content;
        this.createTime = createTime;
        this.updateTime = updateTime;
    }
}

