/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.github.pnoker.common.entity.base.Base;
import io.github.pnoker.common.enums.EnableFlagEnum;
import io.github.pnoker.common.valid.Auth;
import io.github.pnoker.common.valid.Insert;
import io.github.pnoker.common.valid.Update;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@TableName(value="dc3_tenant")
public class Tenant
extends Base {
    @NotBlank(message="Tenant name can't be empty", groups={Insert.class, Auth.class})
    @Pattern(regexp="^[A-Za-z0-9\\u4e00-\\u9fa5][A-Za-z0-9\\u4e00-\\u9fa5-_#@/.|]{1,31}$", message="Invalid tenant name", groups={Insert.class, Update.class})
    private @NotBlank(message="Tenant name can't be empty", groups={Insert.class, Auth.class}) @Pattern(regexp="^[A-Za-z0-9\\u4e00-\\u9fa5][A-Za-z0-9\\u4e00-\\u9fa5-_#@/.|]{1,31}$", message="Invalid tenant name", groups={Insert.class, Update.class}) String tenantName;
    @NotBlank(message="Tenant code can't be empty", groups={Insert.class})
    @Pattern(regexp="^[A-Za-z0-9][A-Za-z0-9-_#@/.|]{1,31}$", message="Invalid tenant code", groups={Insert.class, Update.class})
    private @NotBlank(message="Tenant code can't be empty", groups={Insert.class}) @Pattern(regexp="^[A-Za-z0-9][A-Za-z0-9-_#@/.|]{1,31}$", message="Invalid tenant code", groups={Insert.class, Update.class}) String tenantCode;
    private EnableFlagEnum enableFlag;

    public String getTenantName() {
        return this.tenantName;
    }

    public String getTenantCode() {
        return this.tenantCode;
    }

    public EnableFlagEnum getEnableFlag() {
        return this.enableFlag;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public void setEnableFlag(EnableFlagEnum enableFlag) {
        this.enableFlag = enableFlag;
    }

    public Tenant() {
    }

    public Tenant(String tenantName, String tenantCode, EnableFlagEnum enableFlag) {
        this.tenantName = tenantName;
        this.tenantCode = tenantCode;
        this.enableFlag = enableFlag;
    }

    @Override
    public String toString() {
        return "Tenant(super=" + super.toString() + ", tenantName=" + this.getTenantName() + ", tenantCode=" + this.getTenantCode() + ", enableFlag=" + this.getEnableFlag() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tenant)) {
            return false;
        }
        Tenant other = (Tenant)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$tenantName = this.getTenantName();
        String other$tenantName = other.getTenantName();
        if (this$tenantName == null ? other$tenantName != null : !this$tenantName.equals(other$tenantName)) {
            return false;
        }
        String this$tenantCode = this.getTenantCode();
        String other$tenantCode = other.getTenantCode();
        if (this$tenantCode == null ? other$tenantCode != null : !this$tenantCode.equals(other$tenantCode)) {
            return false;
        }
        EnableFlagEnum this$enableFlag = this.getEnableFlag();
        EnableFlagEnum other$enableFlag = other.getEnableFlag();
        return !(this$enableFlag == null ? other$enableFlag != null : !this$enableFlag.equals(other$enableFlag));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Tenant;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $tenantName = this.getTenantName();
        result = result * 59 + ($tenantName == null ? 43 : $tenantName.hashCode());
        String $tenantCode = this.getTenantCode();
        result = result * 59 + ($tenantCode == null ? 43 : $tenantCode.hashCode());
        EnableFlagEnum $enableFlag = this.getEnableFlag();
        result = result * 59 + ($enableFlag == null ? 43 : $enableFlag.hashCode());
        return result;
    }
}

