/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.entity.dto;

import io.github.pnoker.common.enums.DeviceEventTypeEnum;
import io.github.pnoker.common.enums.DeviceStatusEnum;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;

public class DeviceEventDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DeviceEventTypeEnum type;
    private String content;
    private LocalDateTime createTime;

    public DeviceEventDTO(DeviceEventTypeEnum type, String content) {
        this.type = type;
        this.content = content;
        this.createTime = LocalDateTime.now();
    }

    public static DeviceEventDTOBuilder builder() {
        return new DeviceEventDTOBuilder();
    }

    public DeviceEventTypeEnum getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public void setType(DeviceEventTypeEnum type) {
        this.type = type;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public DeviceEventDTO() {
    }

    public DeviceEventDTO(DeviceEventTypeEnum type, String content, LocalDateTime createTime) {
        this.type = type;
        this.content = content;
        this.createTime = createTime;
    }

    public static class DeviceEventDTOBuilder {
        private DeviceEventTypeEnum type;
        private String content;
        private LocalDateTime createTime;

        DeviceEventDTOBuilder() {
        }

        public DeviceEventDTOBuilder type(DeviceEventTypeEnum type) {
            this.type = type;
            return this;
        }

        public DeviceEventDTOBuilder content(String content) {
            this.content = content;
            return this;
        }

        public DeviceEventDTOBuilder createTime(LocalDateTime createTime) {
            this.createTime = createTime;
            return this;
        }

        public DeviceEventDTO build() {
            return new DeviceEventDTO(this.type, this.content, this.createTime);
        }

        public String toString() {
            return "DeviceEventDTO.DeviceEventDTOBuilder(type=" + String.valueOf(this.type) + ", content=" + this.content + ", createTime=" + String.valueOf(this.createTime) + ")";
        }
    }

    public static class DeviceStatus
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long deviceId;
        private DeviceStatusEnum status;
        private int timeOut;
        private TimeUnit timeUnit;
        private LocalDateTime createTime;

        public DeviceStatus(Long deviceId, DeviceStatusEnum status) {
            this.deviceId = deviceId;
            this.status = status;
            this.createTime = LocalDateTime.now();
        }

        public DeviceStatus(Long deviceId, DeviceStatusEnum status, int timeOut, TimeUnit timeUnit) {
            this.deviceId = deviceId;
            this.status = status;
            this.timeOut = timeOut;
            this.timeUnit = timeUnit;
            this.createTime = LocalDateTime.now();
        }

        private static int $default$timeOut() {
            return 15;
        }

        private static TimeUnit $default$timeUnit() {
            return TimeUnit.MINUTES;
        }

        public static DeviceStatusBuilder builder() {
            return new DeviceStatusBuilder();
        }

        public Long getDeviceId() {
            return this.deviceId;
        }

        public DeviceStatusEnum getStatus() {
            return this.status;
        }

        public int getTimeOut() {
            return this.timeOut;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public LocalDateTime getCreateTime() {
            return this.createTime;
        }

        public void setDeviceId(Long deviceId) {
            this.deviceId = deviceId;
        }

        public void setStatus(DeviceStatusEnum status) {
            this.status = status;
        }

        public void setTimeOut(int timeOut) {
            this.timeOut = timeOut;
        }

        public void setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
        }

        public void setCreateTime(LocalDateTime createTime) {
            this.createTime = createTime;
        }

        public DeviceStatus() {
            this.timeOut = DeviceStatus.$default$timeOut();
            this.timeUnit = DeviceStatus.$default$timeUnit();
        }

        public DeviceStatus(Long deviceId, DeviceStatusEnum status, int timeOut, TimeUnit timeUnit, LocalDateTime createTime) {
            this.deviceId = deviceId;
            this.status = status;
            this.timeOut = timeOut;
            this.timeUnit = timeUnit;
            this.createTime = createTime;
        }

        public static class DeviceStatusBuilder {
            private Long deviceId;
            private DeviceStatusEnum status;
            private boolean timeOut$set;
            private int timeOut$value;
            private boolean timeUnit$set;
            private TimeUnit timeUnit$value;
            private LocalDateTime createTime;

            DeviceStatusBuilder() {
            }

            public DeviceStatusBuilder deviceId(Long deviceId) {
                this.deviceId = deviceId;
                return this;
            }

            public DeviceStatusBuilder status(DeviceStatusEnum status) {
                this.status = status;
                return this;
            }

            public DeviceStatusBuilder timeOut(int timeOut) {
                this.timeOut$value = timeOut;
                this.timeOut$set = true;
                return this;
            }

            public DeviceStatusBuilder timeUnit(TimeUnit timeUnit) {
                this.timeUnit$value = timeUnit;
                this.timeUnit$set = true;
                return this;
            }

            public DeviceStatusBuilder createTime(LocalDateTime createTime) {
                this.createTime = createTime;
                return this;
            }

            public DeviceStatus build() {
                int timeOut$value = this.timeOut$value;
                if (!this.timeOut$set) {
                    timeOut$value = DeviceStatus.$default$timeOut();
                }
                TimeUnit timeUnit$value = this.timeUnit$value;
                if (!this.timeUnit$set) {
                    timeUnit$value = DeviceStatus.$default$timeUnit();
                }
                return new DeviceStatus(this.deviceId, this.status, timeOut$value, timeUnit$value, this.createTime);
            }

            public String toString() {
                return "DeviceEventDTO.DeviceStatus.DeviceStatusBuilder(deviceId=" + this.deviceId + ", status=" + String.valueOf(this.status) + ", timeOut$value=" + this.timeOut$value + ", timeUnit$value=" + String.valueOf((Object)this.timeUnit$value) + ", createTime=" + String.valueOf(this.createTime) + ")";
            }
        }
    }
}

