/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.entity.dto;

import io.github.pnoker.common.enums.DriverEventTypeEnum;
import io.github.pnoker.common.enums.DriverStatusEnum;
import java.io.Serializable;
import java.time.LocalDateTime;

public class DriverEventDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DriverEventTypeEnum type;
    private String content;
    private LocalDateTime createTime;

    public DriverEventDTO(DriverEventTypeEnum type, String content) {
        this.type = type;
        this.content = content;
        this.createTime = LocalDateTime.now();
    }

    public static DriverEventDTOBuilder builder() {
        return new DriverEventDTOBuilder();
    }

    public DriverEventTypeEnum getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public void setType(DriverEventTypeEnum type) {
        this.type = type;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public DriverEventDTO() {
    }

    public DriverEventDTO(DriverEventTypeEnum type, String content, LocalDateTime createTime) {
        this.type = type;
        this.content = content;
        this.createTime = createTime;
    }

    public static class DriverEventDTOBuilder {
        private DriverEventTypeEnum type;
        private String content;
        private LocalDateTime createTime;

        DriverEventDTOBuilder() {
        }

        public DriverEventDTOBuilder type(DriverEventTypeEnum type) {
            this.type = type;
            return this;
        }

        public DriverEventDTOBuilder content(String content) {
            this.content = content;
            return this;
        }

        public DriverEventDTOBuilder createTime(LocalDateTime createTime) {
            this.createTime = createTime;
            return this;
        }

        public DriverEventDTO build() {
            return new DriverEventDTO(this.type, this.content, this.createTime);
        }

        public String toString() {
            return "DriverEventDTO.DriverEventDTOBuilder(type=" + String.valueOf(this.type) + ", content=" + this.content + ", createTime=" + String.valueOf(this.createTime) + ")";
        }
    }

    public static class DriverStatus
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long driverId;
        private DriverStatusEnum status;
        private LocalDateTime createTime;

        public DriverStatus(Long driverId, DriverStatusEnum status) {
            this.driverId = driverId;
            this.status = status;
            this.createTime = LocalDateTime.now();
        }

        public Long getDriverId() {
            return this.driverId;
        }

        public DriverStatusEnum getStatus() {
            return this.status;
        }

        public LocalDateTime getCreateTime() {
            return this.createTime;
        }

        public void setDriverId(Long driverId) {
            this.driverId = driverId;
        }

        public void setStatus(DriverStatusEnum status) {
            this.status = status;
        }

        public void setCreateTime(LocalDateTime createTime) {
            this.createTime = createTime;
        }

        public DriverStatus() {
        }

        public DriverStatus(Long driverId, DriverStatusEnum status, LocalDateTime createTime) {
            this.driverId = driverId;
            this.status = status;
            this.createTime = createTime;
        }
    }
}

