/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;

@Configuration
public class MongoConfig {
    private static final Logger log = LoggerFactory.getLogger(MongoConfig.class);
    private final MongoDatabaseFactory factory;
    private final MongoMappingContext context;

    public MongoConfig(MongoDatabaseFactory factory, MongoMappingContext context) {
        this.factory = factory;
        this.context = context;
    }

    @Bean
    public MappingMongoConverter mappingMongoConverter(BeanFactory beanFactory) {
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(this.factory);
        MappingMongoConverter mappingConverter = new MappingMongoConverter((DbRefResolver)dbRefResolver, (MappingContext)this.context);
        try {
            mappingConverter.setCustomConversions((CustomConversions)beanFactory.getBean(CustomConversions.class));
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        mappingConverter.setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        return mappingConverter;
    }
}

