/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.mongo.repository;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.github.pnoker.common.entity.bo.PointValueBO;
import io.github.pnoker.common.entity.common.Pages;
import io.github.pnoker.common.entity.query.PointValueQuery;
import io.github.pnoker.common.mongo.entity.builder.MgPointValueBuilder;
import io.github.pnoker.common.mongo.entity.model.MgPointValueDO;
import io.github.pnoker.common.repository.RepositoryService;
import io.github.pnoker.common.strategy.RepositoryStrategyFactory;
import io.github.pnoker.common.utils.FieldUtil;
import jakarta.annotation.Resource;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.SortOperation;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service(value="mongoRepositoryService")
public class MongoRepositoryServiceImpl
implements RepositoryService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MongoRepositoryServiceImpl.class);
    @Resource
    private MgPointValueBuilder mgPointValueBuilder;
    @Resource
    private MongoTemplate mongoTemplate;

    public String getRepositoryName() {
        return "mongo";
    }

    public void savePointValue(PointValueBO entityBO) {
        if (Objects.isNull(entityBO.getDeviceId()) || Objects.isNull(entityBO.getPointId())) {
            return;
        }
        String collection = "point_value_" + entityBO.getDeviceId();
        this.ensurePointValueIndex(collection);
        MgPointValueDO entityDO = this.mgPointValueBuilder.buildMgDOByBO(entityBO);
        this.mongoTemplate.insert((Object)entityDO, collection);
    }

    public void savePointValue(Long deviceId, List<PointValueBO> entityBOList) {
        if (Objects.isNull(deviceId)) {
            return;
        }
        String collection = "point_value_" + deviceId;
        this.ensurePointValueIndex(collection);
        List<MgPointValueDO> entityDOList = this.mgPointValueBuilder.buildMgDOListByBOList(entityBOList);
        entityDOList = entityDOList.stream().filter(entityBO -> Objects.nonNull(entityBO.getPointId())).toList();
        this.mongoTemplate.insert(entityDOList, collection);
    }

    public List<String> selectHistoryPointValue(Long deviceId, Long pointId, int count) {
        Criteria criteria = new Criteria();
        Query query = new Query((CriteriaDefinition)criteria);
        criteria.and(FieldUtil.getField(MgPointValueDO::getDeviceId)).is((Object)deviceId).and(FieldUtil.getField(MgPointValueDO::getPointId)).is((Object)pointId);
        query.fields().include(FieldUtil.getField(MgPointValueDO::getValue)).exclude(FieldUtil.getField(MgPointValueDO::getId));
        query.limit(count).with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{FieldUtil.getField(MgPointValueDO::getCreateTime)}));
        List entityDOList = this.mongoTemplate.find(query, MgPointValueDO.class, "point_value_" + deviceId);
        return entityDOList.stream().map(MgPointValueDO::getValue).toList();
    }

    public PointValueBO selectLatestPointValue(Long deviceId, Long pointId) {
        Criteria criteria = new Criteria();
        Query query = new Query((CriteriaDefinition)criteria);
        criteria.and(FieldUtil.getField(MgPointValueDO::getDeviceId)).is((Object)deviceId).and(FieldUtil.getField(MgPointValueDO::getPointId)).is((Object)pointId);
        query.fields().include(FieldUtil.getField(MgPointValueDO::getValue)).exclude(FieldUtil.getField(MgPointValueDO::getId));
        query.limit(1).with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{FieldUtil.getField(MgPointValueDO::getCreateTime)}));
        MgPointValueDO entityDO = (MgPointValueDO)this.mongoTemplate.findOne(query, MgPointValueDO.class, "point_value_" + deviceId);
        return this.mgPointValueBuilder.buildBOByMgDO(entityDO);
    }

    public List<PointValueBO> selectLatestPointValue(Long deviceId, List<Long> pointIds) {
        if (CollUtil.isEmpty(pointIds)) {
            return Collections.emptyList();
        }
        Criteria criteria = new Criteria();
        criteria.and(FieldUtil.getField(MgPointValueDO::getPointId)).in(pointIds);
        MatchOperation match = Aggregation.match((Criteria)criteria);
        SortOperation sort = Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{FieldUtil.getField(MgPointValueDO::getCreateTime)});
        GroupOperation group = Aggregation.group((String[])new String[]{FieldUtil.getField(MgPointValueDO::getPointId)}).first(FieldUtil.getField(MgPointValueDO::getId)).as(FieldUtil.getField(MgPointValueDO::getId)).first(FieldUtil.getField(MgPointValueDO::getDeviceId)).as(FieldUtil.getField(MgPointValueDO::getDeviceId)).first(FieldUtil.getField(MgPointValueDO::getPointId)).as(FieldUtil.getField(MgPointValueDO::getPointId)).first(FieldUtil.getField(MgPointValueDO::getRawValue)).as(FieldUtil.getField(MgPointValueDO::getRawValue)).first(FieldUtil.getField(MgPointValueDO::getValue)).as(FieldUtil.getField(MgPointValueDO::getValue)).first(FieldUtil.getField(MgPointValueDO::getOriginTime)).as(FieldUtil.getField(MgPointValueDO::getOriginTime)).first(FieldUtil.getField(MgPointValueDO::getCreateTime)).as(FieldUtil.getField(MgPointValueDO::getCreateTime));
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{match, sort, group});
        String collection = "point_value_" + deviceId;
        AggregationResults aggregate = this.mongoTemplate.aggregate(aggregation, collection, MgPointValueDO.class);
        List entityDOList = aggregate.getMappedResults();
        return this.mgPointValueBuilder.buildBOListByDOList(entityDOList);
    }

    public Page<PointValueBO> selectPagePointValue(PointValueQuery entityQuery) {
        Pages pages;
        if (Objects.isNull(entityQuery.getPage())) {
            entityQuery.setPage(new Pages());
        }
        Page entityPageBO = new Page();
        Criteria criteria = new Criteria();
        Query query = new Query((CriteriaDefinition)criteria);
        if (Objects.nonNull(entityQuery.getDeviceId())) {
            criteria.and(FieldUtil.getField(MgPointValueDO::getDeviceId)).is((Object)entityQuery.getDeviceId());
        }
        if (Objects.nonNull(entityQuery.getPointId())) {
            criteria.and(FieldUtil.getField(MgPointValueDO::getPointId)).is((Object)entityQuery.getPointId());
        }
        if ((pages = entityQuery.getPage()).getStartTime() > 0L && pages.getEndTime() > 0L && pages.getStartTime() <= pages.getEndTime()) {
            criteria.and(FieldUtil.getField(MgPointValueDO::getCreateTime)).gte((Object)new Date(pages.getStartTime())).lte((Object)new Date(pages.getEndTime()));
        }
        String collection = Objects.nonNull(entityQuery.getDeviceId()) ? "point_value_" + entityQuery.getDeviceId() : "point_value";
        long count = this.mongoTemplate.count(query, collection);
        query.limit((int)pages.getSize()).skip(pages.getSize() * (pages.getCurrent() - 1L));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{FieldUtil.getField(MgPointValueDO::getCreateTime)}));
        List pointValueDOList = this.mongoTemplate.find(query, MgPointValueDO.class, collection);
        List<PointValueBO> pointValueBOList = this.mgPointValueBuilder.buildBOListByDOList(pointValueDOList);
        entityPageBO.setCurrent(pages.getCurrent()).setSize(pages.getSize()).setTotal(count).setRecords(pointValueBOList);
        return entityPageBO;
    }

    public void afterPropertiesSet() {
        RepositoryStrategyFactory.put((String)"mongo", (RepositoryService)this);
    }

    private void ensurePointValueIndex(String collection) {
        Index pointIndex = new Index();
        pointIndex.background().on("pointId", Sort.Direction.DESC).named("IX_point_id");
        this.mongoTemplate.indexOps(collection).ensureIndex((IndexDefinition)pointIndex);
        Index timeIndex = new Index();
        timeIndex.background().on("createTime", Sort.Direction.DESC).named("IX_create_time");
        this.mongoTemplate.indexOps(collection).ensureIndex((IndexDefinition)timeIndex);
    }
}

