/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.config;

import io.github.pnoker.common.mqtt.entity.property.MqttProperties;
import io.github.pnoker.common.utils.JsonUtil;
import io.github.pnoker.common.utils.MqttUtil;
import java.util.ArrayList;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.mqtt.core.DefaultMqttPahoClientFactory;
import org.springframework.integration.mqtt.core.MqttPahoClientFactory;
import org.springframework.integration.mqtt.inbound.MqttPahoMessageDrivenChannelAdapter;
import org.springframework.integration.mqtt.outbound.MqttPahoMessageHandler;
import org.springframework.integration.mqtt.support.DefaultPahoMessageConverter;
import org.springframework.integration.mqtt.support.MqttMessageConverter;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;

@Configuration
public class MqttConfig {
    private static final Logger log = LoggerFactory.getLogger(MqttConfig.class);
    private final MqttProperties mqttProperties;

    public MqttConfig(MqttProperties mqttProperties) {
        this.mqttProperties = mqttProperties;
    }

    @Bean
    public MessageChannel mqttInboundChannel() {
        return new DirectChannel();
    }

    @Bean
    public MessageChannel mqttOutboundChannel() {
        return new DirectChannel();
    }

    @Bean
    public MqttPahoClientFactory mqttClientFactory() {
        DefaultMqttPahoClientFactory factory = new DefaultMqttPahoClientFactory();
        factory.setConnectionOptions(MqttUtil.getMqttConnectOptions(this.mqttProperties));
        return factory;
    }

    @Bean
    public MessageProducer mqttInbound(MqttPahoClientFactory mqttClientFactory) {
        if (Objects.isNull(this.mqttProperties.getReceiveTopics())) {
            this.mqttProperties.setReceiveTopics(new ArrayList<MqttProperties.Topic>());
        }
        this.mqttProperties.getReceiveTopics().forEach(topic -> topic.setName(this.mqttProperties.getTopicPrefix() + topic.getName()));
        MqttPahoMessageDrivenChannelAdapter adapter = new MqttPahoMessageDrivenChannelAdapter(this.mqttProperties.getClient() + "_in", mqttClientFactory, (String[])this.mqttProperties.getReceiveTopics().stream().map(MqttProperties.Topic::getName).toArray(String[]::new));
        adapter.setQos(this.mqttProperties.getReceiveTopics().stream().mapToInt(MqttProperties.Topic::getQos).toArray());
        adapter.setOutputChannel(this.mqttInboundChannel());
        adapter.setConverter((MqttMessageConverter)new DefaultPahoMessageConverter());
        adapter.setCompletionTimeout((long)this.mqttProperties.getCompletionTimeout().intValue());
        log.info("Set receive topics: {}", (Object)JsonUtil.toJsonString(this.mqttProperties.getReceiveTopics()));
        return adapter;
    }

    @Bean
    @ServiceActivator(inputChannel="mqttOutboundChannel")
    public MessageHandler mqttOutbound(MqttPahoClientFactory mqttClientFactory) {
        this.mqttProperties.getDefaultSendTopic().setName(this.mqttProperties.getTopicPrefix() + this.mqttProperties.getDefaultSendTopic().getName());
        MqttPahoMessageHandler messageHandler = new MqttPahoMessageHandler(this.mqttProperties.getClient() + "_out", mqttClientFactory);
        messageHandler.setAsync(true);
        messageHandler.setDefaultQos(this.mqttProperties.getDefaultSendTopic().getQos().intValue());
        messageHandler.setDefaultTopic(this.mqttProperties.getDefaultSendTopic().getName());
        log.info("Set default send topic: {}", (Object)JsonUtil.toJsonString((Object)this.mqttProperties.getDefaultSendTopic()));
        return messageHandler;
    }
}

