/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.rules.DbColumnType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MybatisUtil {
    private static final Logger log = LoggerFactory.getLogger(MybatisUtil.class);

    private MybatisUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static FastAutoGenerator defaultGenerator(String defaultHost, String defaultPort, String defaultDb, String defaultUsername, String defaultPassword) {
        String password;
        String username;
        String db;
        String port;
        String host = System.getenv("MYSQL_HOST");
        if (CharSequenceUtil.isEmpty((CharSequence)host)) {
            host = defaultHost;
        }
        if (CharSequenceUtil.isEmpty((CharSequence)(port = System.getenv("MYSQL_PORT")))) {
            port = defaultPort;
        }
        if (CharSequenceUtil.isEmpty((CharSequence)(db = System.getenv("MYSQL_DB")))) {
            db = defaultDb;
        }
        if (CharSequenceUtil.isEmpty((CharSequence)(username = System.getenv("MYSQL_USERNAME")))) {
            username = defaultUsername;
        }
        if (CharSequenceUtil.isEmpty((CharSequence)(password = System.getenv("MYSQL_PASSWORD")))) {
            password = defaultPassword;
        }
        return FastAutoGenerator.create((String)String.format("jdbc:mysql://%s:%s/%s?useSSL=false", host, port, db), (String)username, (String)password);
    }

    public static void defaultGlobalConfig(GlobalConfig.Builder builder, String path) {
        builder.outputDir(path + "/java").author("pnoker").disableOpenDir();
    }

    public static void defaultDataSourceConfig(DataSourceConfig.Builder builder) {
        builder.typeConvertHandler((globalConfig, typeRegistry, metaInfo) -> {
            int typeCode = metaInfo.getJdbcType().TYPE_CODE;
            if (typeCode == 5) {
                return DbColumnType.INTEGER;
            }
            return typeRegistry.getColumnType(metaInfo);
        });
    }

    public static void defaultStrategyConfig(StrategyConfig.Builder builder) {
        builder.addTablePrefix(new String[]{"dc3_"}).entityBuilder().idType(IdType.ASSIGN_ID).enableLombok().formatFileName("%sDO").enableTableFieldAnnotation().enableRemoveIsPrefix().enableFileOverride().logicDeleteColumnName("deleted").serviceBuilder().formatServiceFileName("%sManager").formatServiceImplFileName("%sManagerImpl").enableFileOverride().mapperBuilder().enableFileOverride();
    }
}

