/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.prometheus.dashboard.rabbitmq.controller;

import io.github.pnoker.common.entity.R;
import io.github.pnoker.common.prometheus.dashboard.rabbitmq.entity.vo.RabbitMQDataVo;
import io.github.pnoker.common.prometheus.dashboard.rabbitmq.service.RabbitMQMessageService;
import jakarta.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/rabbitmq/message"})
public class RabbitMQMessageController {
    private static final Logger log = LoggerFactory.getLogger(RabbitMQMessageController.class);
    @Resource
    private RabbitMQMessageService rabbitMQMessageService;

    @GetMapping(value={"/message_in"})
    public Mono<R<RabbitMQDataVo>> queryInMess(@RequestParam String cluster) {
        try {
            RabbitMQDataVo rabbbit = this.rabbitMQMessageService.queryMQInMess(cluster);
            if (!rabbbit.getTimes().isEmpty() && !rabbbit.getValues().isEmpty()) {
                return Mono.just((Object)R.ok((Object)rabbbit));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Mono.just((Object)R.fail((String)e.getMessage()));
        }
        return Mono.just((Object)R.fail());
    }

    @GetMapping(value={"/message_ready"})
    public Mono<R<RabbitMQDataVo>> queryReMess(@RequestParam String cluster) {
        try {
            RabbitMQDataVo rabbbit = this.rabbitMQMessageService.queryMQReMess(cluster);
            if (!rabbbit.getTimes().isEmpty() && !rabbbit.getValues().isEmpty()) {
                return Mono.just((Object)R.ok((Object)rabbbit));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Mono.just((Object)R.fail((String)e.getMessage()));
        }
        return Mono.just((Object)R.fail());
    }

    @GetMapping(value={"/message_unack"})
    public Mono<R<RabbitMQDataVo>> queryUnackMess(@RequestParam String cluster) {
        try {
            RabbitMQDataVo rabbbit = this.rabbitMQMessageService.queryMQUnackMess(cluster);
            if (!rabbbit.getTimes().isEmpty() && !rabbbit.getValues().isEmpty()) {
                return Mono.just((Object)R.ok((Object)rabbbit));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Mono.just((Object)R.fail((String)e.getMessage()));
        }
        return Mono.just((Object)R.fail());
    }

    @GetMapping(value={"/message_out"})
    public Mono<R<RabbitMQDataVo>> queryOutMess(@RequestParam String cluster) {
        try {
            RabbitMQDataVo rabbbit = this.rabbitMQMessageService.queryMQOutMess(cluster);
            if (!rabbbit.getTimes().isEmpty() && !rabbbit.getValues().isEmpty()) {
                return Mono.just((Object)R.ok((Object)rabbbit));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Mono.just((Object)R.fail((String)e.getMessage()));
        }
        return Mono.just((Object)R.fail());
    }
}

